/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.stl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;

final class MeshSmoother {
    private static final int FIRST_SMGR_ID = 1;
    private static final int NUM_SMGR_IDS = 32;
    private int[] triangleDone = null;

    MeshSmoother() {
    }

    void clear() {
    }

    void close() {
        this.triangleDone = null;
    }

    ArrayList<SmoothMesh> create(int[] nArray, int n, int[] nArray2) {
        int[] nArray3 = this.createNeighbours(nArray);
        this.createSmoothNeighbours(nArray3, nArray, nArray2);
        return this.createSmoothSubMeshesList3(nArray, n, nArray3);
    }

    private ArrayList<SmoothMesh> createSmoothSubMeshesList3(int[] nArray, int n, int[] nArray2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = nArray.length / 3;
        ArrayList<SmoothMesh> arrayList = new ArrayList<SmoothMesh>();
        if (this.triangleDone == null || this.triangleDone.length < n6) {
            this.triangleDone = new int[n6];
        }
        Arrays.fill(this.triangleDone, -2);
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n6; ++i) {
            if (this.triangleDone[i] != -2) continue;
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            SmoothMesh smoothMesh = new SmoothMesh(arrayList2);
            n2 = 0;
            int n7 = n5 = i * 3;
            int n8 = n5 + 1;
            int n9 = n5 + 2;
            arrayList2.add(n7);
            arrayList2.add(n8);
            arrayList2.add(n9);
            this.triangleDone[i] = 0;
            n2 += 3;
            if (nArray2[n7] > -1 || nArray2[n8] > -1 || nArray2[n9] > -1) {
                for (int j = 0; j < n2; ++j) {
                    Object object;
                    n3 = (Integer)arrayList2.get(j);
                    if (nArray2[n3] > -1) {
                        n4 = (int)Math.floor(nArray2[n3] / 3);
                        if (this.triangleDone[n4] != -2) continue;
                        n5 = n4 * 3;
                        arrayList2.add(n5);
                        arrayList2.add(n5 + 1);
                        arrayList2.add(n5 + 2);
                        this.triangleDone[n4] = 0;
                        n2 += 3;
                        continue;
                    }
                    int n10 = nArray[n3];
                    int n11 = arrayList.size();
                    int[] nArray3 = nArrayArray[n10];
                    if (nArray3 == null) {
                        nArray3 = new int[7];
                        Arrays.fill(nArray3, -1);
                        nArray3[0] = n11;
                        nArrayArray[n10] = nArray3;
                        continue;
                    }
                    int n12 = -1;
                    int n13 = nArray3.length;
                    for (int k = 0; k < n13 && (n12 = nArray3[k]) != n11 && n12 >= 0; ++k) {
                        object = arrayList.get(n12);
                        ((SmoothMesh)object).setSmGrBitOn(smoothMesh);
                    }
                    if (n12 < 0) {
                        nArray3[k] = n11;
                        continue;
                    }
                    if (n12 == n11) continue;
                    int[] nArray4 = nArray3;
                    object = new int[nArray3.length + 2];
                    System.arraycopy(nArray4, 0, object, 0, nArray3.length);
                    object[nArray3.length] = n11;
                    nArrayArray[n10] = object;
                }
            } else {
                smoothMesh.setAsSingleTriangle();
            }
            arrayList.add(smoothMesh);
            smoothMesh.determineSmGr();
        }
        return arrayList;
    }

    private void createSmoothNeighbours(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = 0;
        boolean bl = false;
        int n2 = nArray3.length;
        for (int i = 0; i < n2; ++i) {
            n = nArray[i];
            if (n < 0) continue;
            bl = false;
            int n3 = i;
            int n4 = i % 3 == 2 ? i - 2 : i + 1;
            int n5 = n;
            int n6 = n % 3 == 2 ? n - 2 : n + 1;
            int n7 = n % 3 == 2 ? n - 2 : n + 1;
            if (nArray2[i] == nArray2[n7]) {
                if (nArray3[n3] != nArray3[n6]) {
                    bl = true;
                } else if (nArray3[n4] != nArray3[n5]) {
                    bl = true;
                }
            } else if (nArray3[n3] != nArray3[n5]) {
                bl = true;
            } else if (nArray3[n4] != nArray3[n6]) {
                bl = true;
            }
            if (!bl) continue;
            nArray[i] = -1;
            nArray[n] = -1;
        }
    }

    private int[] createNeighbours(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        Arrays.fill(nArray2, -2);
        int n2 = 20 + n / 20;
        HashMap<Edge, Integer> hashMap = new HashMap<Edge, Integer>(n2);
        hashMap.put(new Edge(nArray[0], nArray[1]), 0);
        hashMap.put(new Edge(nArray[1], nArray[2]), 1);
        hashMap.put(new Edge(nArray[2], nArray[0]), 2);
        for (int i = 3; i < n; i += 3) {
            Edge edge = new Edge(nArray[i], nArray[i + 1]);
            Integer n3 = (Integer)hashMap.remove(edge);
            if (n3 == null) {
                hashMap.put(edge, i);
            } else {
                nArray2[i] = n3;
                nArray2[n3.intValue()] = i;
            }
            Edge edge2 = new Edge(nArray[i + 1], nArray[i + 2]);
            n3 = (Integer)hashMap.remove(edge2);
            if (n3 == null) {
                hashMap.put(edge2, i + 1);
            } else {
                nArray2[i + 1] = n3;
                nArray2[n3.intValue()] = i + 1;
            }
            Edge edge3 = new Edge(nArray[i + 2], nArray[i]);
            n3 = (Integer)hashMap.remove(edge3);
            if (n3 == null) {
                hashMap.put(edge3, i + 2);
                continue;
            }
            nArray2[i + 2] = n3;
            nArray2[n3.intValue()] = i + 2;
        }
        return nArray2;
    }

    private static final class Edge {
        private final int a;
        private final int b;
        private final int hashCode;

        private Edge(int n, int n2) {
            this.a = n;
            this.b = n2;
            this.hashCode = n + n2;
        }

        public boolean equals(Object object) {
            Edge edge = (Edge)object;
            return this.a == edge.a && this.b == edge.b || this.a == edge.b && this.b == edge.a;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    static final class SmoothMesh {
        private ArrayList<Integer> smoothMeshIndices = null;
        private final BitSet smGrSet = new BitSet(33);
        private int smGr = -1;
        int smGrN = 0;
        private boolean isSingle = false;

        private SmoothMesh(ArrayList<Integer> arrayList) {
            this.smoothMeshIndices = arrayList;
        }

        ArrayList<Integer> getIndices() {
            return this.smoothMeshIndices;
        }

        int getSmGrId() {
            return this.smGr;
        }

        void close() {
            this.smoothMeshIndices = null;
        }

        private void setAsSingleTriangle() {
            this.isSingle = true;
        }

        private void determineSmGr() {
            if (this.isSingle) {
                this.smGr = 0;
            } else {
                this.smGrN = this.smGrSet.nextClearBit(1);
                this.smGr = 1 << this.smGrN - 1;
            }
        }

        private void setSmGrBitOn(SmoothMesh smoothMesh) {
            smoothMesh.smGrSet.set(this.smGrN);
        }
    }
}

