/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.stl;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.stl.Indexer;
import com.interactivemesh.jfx.importer.stl.MeshSmoother;
import com.interactivemesh.jfx.importer.stl.Normalizer;
import com.interactivemesh.jfx.importer.stl.StlImportOption;
import com.interactivemesh.jfx.importer.stl.StlMeshImporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Locale;
import javafx.scene.shape.TriangleMesh;

final class StlMeshImporterImpl {
    private final EnumSet<StlImportOption> stlOpts = EnumSet.noneOf(StlImportOption.class);
    private double creaseAngle = Math.toRadians(45.0);
    private int initCap = 0x400000;
    private byte[] streamBytes = null;
    private ByteBuffer fChannelBuffer = null;
    private boolean isJavaRounding = true;
    private char[] asciiCharArray = null;
    private int coordsLength = 0;
    private int coordsSize = 0;
    private float[] coordsList = null;
    private int normalsLength = 0;
    private int normalsSize = 0;
    private float[] normalsList = null;
    private float[] coordsArray = null;
    private float[] normalsArray = null;
    private TriangleMesh importedMesh = null;
    private String solidName = null;
    private boolean isClosed = false;
    private final Indexer indexer;
    private final Normalizer normalizer;
    private final MeshSmoother smoother;
    private final StlMeshImporter importer;

    StlMeshImporterImpl(StlMeshImporter stlMeshImporter) {
        this.importer = stlMeshImporter;
        this.indexer = new Indexer();
        this.normalizer = new Normalizer();
        this.smoother = new MeshSmoother();
        this.stlOpts.add(StlImportOption.NONE);
    }

    double getCreaseAngle() {
        return Math.toDegrees(this.creaseAngle);
    }

    void setCreaseAngle(double d) {
        double d2 = Math.toRadians(d);
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > Math.PI) {
            d2 = 3.1415927410125732;
        }
        this.creaseAngle = d2;
    }

    EnumSet<StlImportOption> getOptions() {
        return this.stlOpts.clone();
    }

    void setOptions(StlImportOption ... stlImportOptionArray) {
        if (stlImportOptionArray == null || stlImportOptionArray.length < 1) {
            throw new IllegalArgumentException("options is null || options' length < 1");
        }
        if (stlImportOptionArray.length > 1) {
            for (StlImportOption stlImportOption : stlImportOptionArray) {
                if (stlImportOption != StlImportOption.NONE) continue;
                throw new IllegalArgumentException("options include StlImportOption.NONE");
            }
        }
        this.stlOpts.clear();
        for (StlImportOption stlImportOption : stlImportOptionArray) {
            this.stlOpts.add(stlImportOption);
        }
    }

    void setOptions(EnumSet<StlImportOption> enumSet) {
        if (enumSet == null || enumSet.isEmpty()) {
            throw new IllegalArgumentException("options is null || options is empty");
        }
        if (enumSet.size() > 1) {
            for (StlImportOption stlImportOption : enumSet) {
                if (stlImportOption != StlImportOption.NONE) continue;
                throw new IllegalArgumentException("options include StlImportOption.NONE");
            }
        }
        this.stlOpts.clear();
        this.stlOpts.addAll(enumSet);
    }

    void read(File file) {
        if (this.checkIsClosed()) {
            return;
        }
        if (file == null) {
            throw new ImportException("StlMeshImporter read(File file) : file is null !");
        }
        if (!file.exists()) {
            throw new ImportException("StlMeshImporter read(File file) : file doesn't exist !");
        }
        if (file.isDirectory()) {
            throw new ImportException("StlMeshImporter read(File file) : file is directory !");
        }
        if (!file.canRead()) {
            throw new ImportException("StlMeshImporter read(File file) : file can't be read !");
        }
        try {
            FileChannel fileChannel = new FileInputStream(file).getChannel();
            this.readFromChannel(fileChannel);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ImportException("StlMeshImporter read(File file) : \n" + fileNotFoundException.getMessage(), fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new ImportException("StlMeshImporter read(File file) : \n" + iOException.getMessage(), iOException);
        }
    }

    void read(String string) {
        block16: {
            Object object;
            if (this.checkIsClosed()) {
                return;
            }
            if (string == null || string.length() < 1) {
                throw new ImportException("StlMeshImporter read(String fileName) : fileName is null !");
            }
            URL uRL = null;
            try {
                string = string.replace('\\', '/');
                uRL = this.getUrlForAbsolutPath(string);
                if (uRL == null && ((String)(object = System.getProperty("user.dir"))).length() > 0) {
                    if (((String)(object = ((String)object).replace('\\', '/'))).charAt(0) != '/') {
                        object = '/' + (String)object;
                    }
                    if (((String)object).charAt(((String)object).length() - 1) != '/') {
                        object = (String)object + '/';
                    }
                    uRL = new URL("file", null, this.normalizePath((String)object, string));
                }
                if (uRL == null) {
                    throw new ImportException("StlMeshImporter read(String fileName) : Can' create URL f0r = \n" + string);
                }
            }
            catch (SecurityException securityException) {
                throw new ImportException("StlMeshImporter read(String fileName) : \n" + securityException.getMessage(), securityException);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ImportException("StlMeshImporter read(String fileName) : \n" + malformedURLException.getMessage(), malformedURLException);
            }
            try {
                if (uRL.toExternalForm().indexOf("file") >= 0 && uRL.toExternalForm().indexOf("jar:") < 0) {
                    try {
                        object = new File(uRL.toURI());
                        if (object != null && ((File)object).canRead()) {
                            FileChannel fileChannel = new FileInputStream((File)object).getChannel();
                            this.readFromChannel(fileChannel);
                        }
                        break block16;
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new ImportException("StlMeshImporter read(String fileName) : \n" + uRISyntaxException.getMessage(), uRISyntaxException);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new ImportException("StlMeshImporter read(String fileName) : \n" + fileNotFoundException.getMessage(), fileNotFoundException);
                    }
                }
                object = uRL.openConnection();
                this.readFromStream(((URLConnection)object).getInputStream());
            }
            catch (IOException iOException) {
                throw new ImportException("StlMeshImporter read(String fileName) : \n" + iOException.getMessage(), iOException);
            }
        }
    }

    void read(URL uRL) {
        block9: {
            if (this.checkIsClosed()) {
                return;
            }
            if (uRL == null) {
                throw new ImportException("StlMeshImporter read(URL url) : url is null !");
            }
            try {
                if (uRL.toExternalForm().indexOf("file") >= 0 && uRL.toExternalForm().indexOf("jar:") < 0) {
                    try {
                        File file = new File(uRL.toURI());
                        if (file != null && file.canRead()) {
                            FileChannel fileChannel = new FileInputStream(file).getChannel();
                            this.readFromChannel(fileChannel);
                        }
                        break block9;
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new ImportException("StlMeshImporter read(URL url) : \n" + uRISyntaxException.getMessage(), uRISyntaxException);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new ImportException("StlMeshImporter read(URL url) : \n" + fileNotFoundException.getMessage(), fileNotFoundException);
                    }
                }
                URLConnection uRLConnection = uRL.openConnection();
                this.readFromStream(uRLConnection.getInputStream());
            }
            catch (IOException iOException) {
                throw new ImportException("StlMeshImporter read(URL url) : \n" + iOException.getMessage(), iOException);
            }
        }
    }

    TriangleMesh getImport() {
        return this.importedMesh;
    }

    String getSolidName() {
        return this.solidName;
    }

    void clear() {
        this.coordsLength = 0;
        this.coordsSize = 0;
        this.coordsList = null;
        this.normalsLength = 0;
        this.normalsSize = 0;
        this.normalsList = null;
        this.coordsArray = null;
        this.normalsArray = null;
        this.importedMesh = null;
        this.solidName = null;
    }

    void close() {
        this.isClosed = true;
        this.clear();
        this.indexer.close();
        this.smoother.close();
    }

    private boolean checkIsClosed() {
        if (this.isClosed) {
            throw new ImportException("StlMeshImporter is closed ! Can't be used anymore !");
        }
        return this.isClosed;
    }

    private void createMesh() {
        int n;
        int n2;
        float[] fArray = null;
        float[] fArray2 = null;
        int[] nArray = null;
        int[] nArray2 = null;
        float[] fArray3 = new float[]{0.0f, 0.0f};
        this.indexer.createRFTuples3fAndInds(this.coordsArray);
        nArray = this.indexer.getIndices();
        fArray = this.indexer.getIndexedVerts();
        int n3 = nArray.length;
        int n4 = fArray.length / 3;
        int n5 = n3 / 3;
        this.indexer.clear();
        nArray2 = new int[nArray.length];
        fArray2 = this.stlOpts.contains((Object)StlImportOption.CALCULATE_FACET_NORMAL) ? this.normalizer.calcIndexedVertexNormals(this.creaseAngle, null, fArray, n4, nArray, nArray2) : this.normalizer.calcIndexedVertexNormals(this.creaseAngle, this.normalsArray, null, n4, nArray, nArray2);
        int[] nArray3 = new int[n5];
        int n6 = 0;
        if (!(this.creaseAngle < 0.0)) {
            n6 = 0;
            ArrayList<MeshSmoother.SmoothMesh> arrayList = this.smoother.create(nArray, fArray.length / 3, nArray2);
            n2 = arrayList.size();
            ArrayList<Integer> arrayList2 = null;
            n = 0;
            for (MeshSmoother.SmoothMesh smoothMesh : arrayList) {
                arrayList2 = smoothMesh.getIndices();
                n = smoothMesh.getSmGrId();
                int n7 = arrayList2.size();
                for (int i = 0; i < n7; i += 3) {
                    nArray3[arrayList2.get((int)i).intValue() / 3] = n;
                }
                smoothMesh.close();
                if (n <= n6) continue;
                n6 = n;
            }
            arrayList.clear();
            this.smoother.clear();
        }
        if (this.stlOpts.contains((Object)StlImportOption.REVERSE_GEOMETRY)) {
            int n8 = 3;
            n2 = -1;
            int n9 = n8 - 1;
            for (n = 0; n < n3; n += n8) {
                n2 = nArray[n + n9];
                nArray[n + n9] = nArray[n + 1];
                nArray[n + 1] = n2;
            }
        }
        n2 = fArray.length;
        for (int i = 0; i < n2; i += 3) {
            fArray[i + 1] = -fArray[i + 1];
            fArray[i + 2] = -fArray[i + 2];
        }
        this.importedMesh = new TriangleMesh();
        this.importedMesh.getPoints().addAll(fArray);
        this.importedMesh.getTexCoords().addAll(fArray3);
        int[] nArray4 = new int[n3 * 2];
        n2 = 0;
        for (int i = 0; i < n3; ++i) {
            nArray4[n2++] = nArray[i];
            nArray4[n2++] = 0;
        }
        this.importedMesh.getFaces().addAll(nArray4);
        this.importedMesh.getFaceSmoothingGroups().addAll(nArray3);
        this.importer.onFileImported();
    }

    private void readFromChannel(FileChannel fileChannel) throws IOException {
        this.clear();
        byte[] byArray = new byte[84];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.nativeOrder());
        fileChannel.read(byteBuffer);
        byteBuffer.clear();
        int n = -1;
        int n2 = -1;
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        for (int i = 0; i < 84; ++i) {
            c = (char)(byArray[i] & 0xFF);
            if (n < 0 && c == '\n') {
                n = i;
            }
            if (n2 < 0 && c == '\r') {
                n2 = i;
            }
            stringBuffer.append(c);
        }
        String string = stringBuffer.toString();
        int n3 = string.indexOf("solid");
        boolean bl = false;
        if (n3 >= 0 && (n > 0 || n2 > 0)) {
            int n4 = n;
            if (n4 < 0) {
                n4 = n2;
            }
            this.solidName = string = string.substring(n3 + 5, n4).trim();
            bl = this.readAsciiChannel(fileChannel, byteBuffer, n4 + 1);
        } else {
            int n5 = 80;
            for (int i = 79; i >= 0; --i) {
                if ((byArray[i] & 0xFF) <= 32) continue;
                n5 = i + 1;
                break;
            }
            this.solidName = string.substring(0, n5);
            bl = this.readBinaryChannelFully(fileChannel, byteBuffer);
        }
        if (bl) {
            this.createMesh();
        }
    }

    private void readFromStream(InputStream inputStream) throws IOException {
        this.clear();
        int n = inputStream.available();
        if (n < 100) {
            return;
        }
        int n2 = -1;
        int n3 = -1;
        byte[] byArray = new byte[84];
        inputStream.read(byArray, 0, 84);
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        for (int i = 0; i < 84; ++i) {
            c = (char)(byArray[i] & 0xFF);
            if (n2 < 0 && c == '\n') {
                n2 = i;
            }
            if (n3 < 0 && c == '\r') {
                n3 = i;
            }
            stringBuffer.append(c);
        }
        String string = stringBuffer.toString();
        int n4 = string.indexOf("solid");
        boolean bl = false;
        if (n4 >= 0 && (n2 > 0 || n3 > 0)) {
            int n5 = n2;
            if (n5 < 0) {
                n5 = n3;
            }
            this.solidName = string = string.substring(n4 + 5, n5).trim();
            bl = this.readAsciiStream(inputStream, n, byArray, n5 + 1);
        } else {
            int n6 = 80;
            for (int i = 79; i >= 0; --i) {
                if ((byArray[i] & 0xFF) <= 32) continue;
                n6 = i + 1;
                break;
            }
            this.solidName = string.substring(0, n6);
            bl = this.readBinaryStreamFully(inputStream, n, byArray);
        }
        if (bl) {
            this.createMesh();
        }
    }

    private boolean readAsciiChannel(FileChannel fileChannel, ByteBuffer byteBuffer, int n) throws IOException {
        int n2 = (int)((fileChannel.size() + 4096L) / 208L);
        this.coordsLength = n2 * 9;
        this.normalsLength = n2 * 3;
        this.coordsList = new float[this.coordsLength];
        if (!this.stlOpts.contains((Object)StlImportOption.CALCULATE_FACET_NORMAL)) {
            this.normalsList = new float[this.normalsLength];
        }
        if (this.fChannelBuffer == null) {
            this.fChannelBuffer = ByteBuffer.allocateDirect(this.initCap).order(ByteOrder.nativeOrder());
            if (this.isJavaRounding) {
                this.asciiCharArray = new char[this.initCap];
            }
        }
        this.fChannelBuffer.clear();
        byteBuffer.position(n);
        this.fChannelBuffer.put(byteBuffer);
        int n3 = this.fChannelBuffer.position();
        int n4 = 0;
        int n5 = 0;
        boolean bl = true;
        while (bl) {
            int n6;
            this.fChannelBuffer.position(n3);
            this.fChannelBuffer.limit(this.fChannelBuffer.capacity());
            n5 = fileChannel.read(this.fChannelBuffer);
            if (n5 < 0) {
                bl = false;
                continue;
            }
            if (n5 <= 0) continue;
            n4 = this.fChannelBuffer.position();
            this.fChannelBuffer.position(0);
            int n7 = -1;
            if (this.isJavaRounding) {
                for (n6 = 0; n6 < n4; ++n6) {
                    this.asciiCharArray[n6] = (char)(this.fChannelBuffer.get() & 0xFF);
                }
                n7 = this.readFacets(this.asciiCharArray, 0, n4);
            }
            if (n7 < 0) {
                bl = false;
                continue;
            }
            n6 = n4 - n7;
            if (n6 > 0) {
                int n8 = 0;
                for (int i = 0; i < n6; ++i) {
                    this.fChannelBuffer.put(n8++, this.fChannelBuffer.get(n7 + i));
                }
                n3 = n6;
                continue;
            }
            n3 = 0;
        }
        fileChannel.close();
        if (!this.stlOpts.contains((Object)StlImportOption.CALCULATE_FACET_NORMAL)) {
            this.normalsArray = new float[this.normalsSize];
            System.arraycopy(this.normalsList, 0, this.normalsArray, 0, this.normalsSize);
        }
        this.coordsArray = new float[this.coordsSize];
        System.arraycopy(this.coordsList, 0, this.coordsArray, 0, this.coordsSize);
        this.normalsList = null;
        this.coordsList = null;
        return true;
    }

    private boolean readAsciiStream(InputStream inputStream, int n, byte[] byArray, int n2) throws IOException {
        int n3;
        int n4 = (n + 4096) / 208;
        this.coordsLength = n4 * 9;
        this.normalsLength = n4 * 3;
        this.coordsList = new float[this.coordsLength];
        if (!this.stlOpts.contains((Object)StlImportOption.CALCULATE_FACET_NORMAL)) {
            this.normalsList = new float[this.normalsLength];
        }
        if (this.streamBytes == null) {
            this.streamBytes = new byte[this.initCap];
            if (this.isJavaRounding) {
                this.asciiCharArray = new char[this.initCap];
            }
        }
        int n5 = 0;
        for (n3 = n2; n3 < byArray.length; ++n3) {
            this.streamBytes[n5++] = byArray[n3];
        }
        n3 = n5;
        int n6 = this.streamBytes.length - n3;
        int n7 = 0;
        int n8 = 0;
        boolean bl = true;
        while (bl) {
            int n9;
            n8 = inputStream.read(this.streamBytes, n3, n6);
            if (n8 < 0) {
                bl = false;
                continue;
            }
            if (n8 <= 0) continue;
            n7 = n3 + n8;
            int n10 = -1;
            if (this.isJavaRounding) {
                for (n9 = 0; n9 < n7; ++n9) {
                    this.asciiCharArray[n9] = (char)(this.streamBytes[n9] & 0xFF);
                }
                n10 = this.readFacets(this.asciiCharArray, 0, n7);
            }
            if (n10 < 0) {
                bl = false;
                continue;
            }
            n9 = n7 - n10;
            if (n9 > 0) {
                n5 = 0;
                for (int i = 0; i < n9; ++i) {
                    this.streamBytes[n5++] = this.streamBytes[n10 + i];
                }
                n3 = n9;
            } else {
                n3 = 0;
            }
            n6 = this.streamBytes.length - n3;
        }
        inputStream.close();
        if (!this.stlOpts.contains((Object)StlImportOption.CALCULATE_FACET_NORMAL)) {
            this.normalsArray = new float[this.normalsSize];
            System.arraycopy(this.normalsList, 0, this.normalsArray, 0, this.normalsSize);
        }
        this.coordsArray = new float[this.coordsSize];
        System.arraycopy(this.coordsList, 0, this.coordsArray, 0, this.coordsSize);
        this.normalsList = null;
        this.coordsList = null;
        return true;
    }

    private int readFacets(char[] cArray, int n, int n2) {
        int n3 = n;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        int n4 = n - 1;
        n4 += 8;
        block0: while (++n4 < n2) {
            if (cArray[n4] != 'l') continue;
            if (cArray[n4 - 1] == 'o') {
                return -1;
            }
            if (!this.stlOpts.contains((Object)StlImportOption.CALCULATE_FACET_NORMAL) && (n4 = this.readThreeFloatsJava(cArray, n4, n2, fArray)) < 0) {
                return n3;
            }
            n4 += 15;
            while (++n4 < n2) {
                if (cArray[n4] != 'x') continue;
                if ((n4 = this.readThreeFloatsJava(cArray, n4, n2, fArray2)) < 0) {
                    return n3;
                }
                n4 += 5;
                while (++n4 < n2) {
                    if (cArray[n4] != 'x') continue;
                    if ((n4 = this.readThreeFloatsJava(cArray, n4, n2, fArray3)) < 0) {
                        return n3;
                    }
                    n4 += 5;
                    while (++n4 < n2) {
                        if (cArray[n4] != 'x') continue;
                        if ((n4 = this.readThreeFloatsJava(cArray, n4, n2, fArray4)) < 0) {
                            return n3;
                        }
                        n4 += 13;
                        while (++n4 < n2) {
                            float[] fArray5;
                            if (cArray[n4] != 't') continue;
                            n3 = n4 + 1;
                            if (!this.stlOpts.contains((Object)StlImportOption.CALCULATE_FACET_NORMAL)) {
                                if (this.normalsSize > this.normalsLength - 3) {
                                    fArray5 = this.normalsList;
                                    this.normalsLength = (int)((double)this.normalsSize * 1.2);
                                    this.normalsList = new float[this.normalsLength];
                                    System.arraycopy(fArray5, 0, this.normalsList, 0, fArray5.length);
                                }
                                this.normalsList[this.normalsSize++] = fArray[0];
                                this.normalsList[this.normalsSize++] = fArray[1];
                                this.normalsList[this.normalsSize++] = fArray[2];
                            }
                            if (this.coordsSize > this.coordsLength - 9) {
                                fArray5 = this.coordsList;
                                this.coordsLength = (int)((double)this.coordsSize * 1.2);
                                this.coordsList = new float[this.coordsLength];
                                System.arraycopy(fArray5, 0, this.coordsList, 0, fArray5.length);
                            }
                            this.coordsList[this.coordsSize++] = fArray2[0];
                            this.coordsList[this.coordsSize++] = fArray2[1];
                            this.coordsList[this.coordsSize++] = fArray2[2];
                            this.coordsList[this.coordsSize++] = fArray3[0];
                            this.coordsList[this.coordsSize++] = fArray3[1];
                            this.coordsList[this.coordsSize++] = fArray3[2];
                            this.coordsList[this.coordsSize++] = fArray4[0];
                            this.coordsList[this.coordsSize++] = fArray4[1];
                            this.coordsList[this.coordsSize++] = fArray4[2];
                            continue block0;
                        }
                    }
                }
            }
        }
        return n3;
    }

    private int readThreeFloatsJava(char[] cArray, int n, int n2, float[] fArray) {
        int n3 = 0;
        int n4 = n;
        int n5 = 0;
        try {
            block2: while (++n4 < n2) {
                if (cArray[n4] <= ' ') continue;
                n3 = n4;
                while (++n4 < n2) {
                    if (cArray[n4] > ' ') continue;
                    fArray[n5++] = Float.parseFloat(new String(cArray, n3, n4 - n3));
                    if (n5 != 3) continue block2;
                    return n4;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return -1;
    }

    private boolean readBinaryChannelFully(FileChannel fileChannel, ByteBuffer byteBuffer) throws IOException {
        byteBuffer.position(0);
        byte[] byArray = new byte[80];
        byteBuffer.get(byArray);
        String string = new String(byArray);
        int n = (int)((long)byteBuffer.getInt() & 0xFFFFFFFFL);
        if (n < 1) {
            fileChannel.close();
            return false;
        }
        if (!this.stlOpts.contains((Object)StlImportOption.CALCULATE_FACET_NORMAL)) {
            this.normalsArray = new float[n * 3];
        }
        this.coordsArray = new float[n * 9];
        int n2 = n * 50;
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n2).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer2.clear();
        int n3 = n2;
        int n4 = 0;
        while ((n4 = fileChannel.read(byteBuffer2)) >= 0 && (n3 -= n4) > 0) {
        }
        if (n3 > 0) {
            fileChannel.close();
            throw new ImportException("Can't read all bytes from channel : still to read =" + n3 + " from total " + n2);
        }
        byteBuffer2.position(0);
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.stlOpts.contains((Object)StlImportOption.CALCULATE_FACET_NORMAL)) {
                byteBuffer2.position(byteBuffer2.position() + 12);
            } else {
                this.normalsArray[n5++] = byteBuffer2.getFloat();
                this.normalsArray[n5++] = byteBuffer2.getFloat();
                this.normalsArray[n5++] = byteBuffer2.getFloat();
            }
            this.coordsArray[n6++] = byteBuffer2.getFloat();
            this.coordsArray[n6++] = byteBuffer2.getFloat();
            this.coordsArray[n6++] = byteBuffer2.getFloat();
            this.coordsArray[n6++] = byteBuffer2.getFloat();
            this.coordsArray[n6++] = byteBuffer2.getFloat();
            this.coordsArray[n6++] = byteBuffer2.getFloat();
            this.coordsArray[n6++] = byteBuffer2.getFloat();
            this.coordsArray[n6++] = byteBuffer2.getFloat();
            this.coordsArray[n6++] = byteBuffer2.getFloat();
            byteBuffer2.getShort();
        }
        fileChannel.close();
        return true;
    }

    private boolean readBinaryStreamFully(InputStream inputStream, int n, byte[] byArray) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.clear();
        String string = new String(byArray, 0, 80);
        byteBuffer.position(80);
        int n2 = (int)((long)byteBuffer.getInt() & 0xFFFFFFFFL);
        if (n2 < 1) {
            inputStream.close();
            return false;
        }
        if (!this.stlOpts.contains((Object)StlImportOption.CALCULATE_FACET_NORMAL)) {
            this.normalsArray = new float[n2 * 3];
        }
        this.coordsArray = new float[n2 * 9];
        int n3 = n2 * 50;
        byte[] byArray2 = new byte[n3];
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray2).order(ByteOrder.LITTLE_ENDIAN);
        int n4 = 0;
        int n5 = n3;
        int n6 = 0;
        do {
            n6 = inputStream.read(byArray2, n4, n5);
            n4 += n6;
        } while (n6 >= 0 && (n5 -= n6) > 0);
        if (n5 > 0) {
            inputStream.close();
            throw new ImportException("Can't read all bytes from stream : still to read =" + n5 + " from total " + n3);
        }
        byteBuffer2.limit(n3);
        byteBuffer2.position(0);
        boolean bl = false;
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < n2; ++i) {
            if (this.stlOpts.contains((Object)StlImportOption.CALCULATE_FACET_NORMAL)) {
                byteBuffer2.position(byteBuffer2.position() + 12);
            } else {
                this.normalsArray[n7++] = byteBuffer2.getFloat();
                this.normalsArray[n7++] = byteBuffer2.getFloat();
                this.normalsArray[n7++] = byteBuffer2.getFloat();
            }
            this.coordsArray[n8++] = byteBuffer2.getFloat();
            this.coordsArray[n8++] = byteBuffer2.getFloat();
            this.coordsArray[n8++] = byteBuffer2.getFloat();
            this.coordsArray[n8++] = byteBuffer2.getFloat();
            this.coordsArray[n8++] = byteBuffer2.getFloat();
            this.coordsArray[n8++] = byteBuffer2.getFloat();
            this.coordsArray[n8++] = byteBuffer2.getFloat();
            this.coordsArray[n8++] = byteBuffer2.getFloat();
            this.coordsArray[n8++] = byteBuffer2.getFloat();
            byteBuffer2.getShort();
        }
        inputStream.close();
        return true;
    }

    private URL getUrlForAbsolutPath(String string) {
        URL uRL = null;
        int n = string.indexOf(":");
        try {
            if (n > 0) {
                String string2 = string.substring(0, n);
                String string3 = string2.toLowerCase(Locale.ENGLISH);
                if (string3.startsWith("jar") || string3.startsWith("http") || string3.startsWith("file") || string3.startsWith("ftp")) {
                    URI uRI = new URI(string);
                    uRL = uRI.toURL();
                } else if (string.charAt(0) != '/') {
                    uRL = new URL("file", null, "/" + string);
                } else {
                    URI uRI = new URI(string);
                    uRL = uRI.toURL();
                }
            } else if (string.charAt(0) == '/') {
                uRL = new URL("file", null, string);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ImportException("StlMeshImporter : Can't create URI !\nPath = " + string + "<!", uRISyntaxException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ImportException("StlMeshImporter : Can't create URL !\nPath = " + string + "<!", malformedURLException);
        }
        return uRL;
    }

    private String normalizePath(String string, String string2) {
        if (string2.indexOf("./") == 0) {
            string2 = string2.substring(2);
            return new String(string + string2);
        }
        int n = -1;
        int n2 = string2.lastIndexOf("../");
        int n3 = 0;
        if (n2 >= 0) {
            n3 = n2 / 3 + 1;
        }
        if (n3 > 0) {
            int n4 = string.length() - 2;
            n = string.lastIndexOf(47, n4);
            if (n < 0) {
                throw new ImportException("StlMeshImporter : normalizePath : lastBaseIndex < 0 ! \nbase = " + string + " child = " + string2);
            }
            --n3;
            while (n3 > 0) {
                if ((n = string.lastIndexOf(47, n - 1)) < 0) {
                    throw new ImportException("StlMeshImporter : normalizePath : lastBaseIndex < 0 ! \nbase = " + string + " child = " + string2);
                }
                --n3;
            }
            return new String(string.substring(0, n + 1) + string2.substring(n2 + 3));
        }
        return new String(string + string2);
    }
}

