/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.fxml;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.Viewpoint;
import com.interactivemesh.jfx.importer.fxml.AbstractElementParser;
import com.interactivemesh.jfx.importer.fxml.FxFileParser;
import com.interactivemesh.jfx.importer.fxml.NodeParser;
import java.util.ArrayList;
import java.util.Iterator;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.PerspectiveCamera;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;

final class CameraParser
extends NodeParser {
    private Group camParent = null;
    private Camera currCamera = null;
    private String tagName = null;
    private String farClip = null;
    private String nearClip = null;
    private String fieldOfView = null;
    private String verticalFieldOfView = null;
    private boolean isPerspective = false;

    CameraParser(FxFileParser fxFileParser) {
        super(fxFileParser);
    }

    void setup(AbstractElementParser abstractElementParser, Camera camera, String string, Group group) {
        this.parentParser = abstractElementParser;
        this.currCamera = camera;
        this.tagName = string;
        this.camParent = group;
        this.isPerspective = string.equals("PerspectiveCamera");
        this.farClip = null;
        this.nearClip = null;
        this.fieldOfView = null;
        this.verticalFieldOfView = null;
        this.setupNode();
        int n = this.fxfp.xR.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String string2 = this.fxfp.xR.getAttributeValue(i);
            if (string2 != null && string2.length() > 0) {
                String string3 = this.fxfp.xR.getAttributeLocalName(i);
                if (string3.equals("farClip")) {
                    this.farClip = string2;
                    continue;
                }
                if (string3.equals("nearClip")) {
                    this.nearClip = string2;
                    continue;
                }
                if (string3.equals("fieldOfView")) {
                    this.fieldOfView = string2;
                    continue;
                }
                if (string3.equals("verticalFieldOfView")) {
                    this.verticalFieldOfView = string2;
                    continue;
                }
                this.processNodeAttributes(string3, string2, i);
                continue;
            }
            throw new ImportException("CameraParser : no value for attribute = " + this.fxfp.xR.getAttributeName(i));
        }
    }

    @Override
    String getIdDefault() {
        return this.tagName;
    }

    @Override
    void close() {
        super.close();
    }

    @Override
    void startElement(String string) {
        if (string.equals("transforms")) {
            this.fxfp.setTransformsParser(this, (Node)this.currCamera);
        } else {
            this.isCharacter = false;
            this.isPrimitive = false;
            if (!this.processNodeStartElement(string)) {
                if (string.equals("farClip")) {
                    this.isCharacter = true;
                } else if (string.equals("nearClip")) {
                    this.isCharacter = true;
                } else if (string.equals("fieldOfView")) {
                    this.isCharacter = true;
                } else if (string.equals("verticalFieldOfView")) {
                    this.isCharacter = true;
                } else if (this.processPrimitiveStartElement(string)) {
                    this.isPrimitive = true;
                } else {
                    this.fxfp.setNullParser(this, string);
                }
            }
            if (this.isCharacter) {
                this.arrPos = 0;
            }
        }
    }

    @Override
    void endElement(String string) {
        if (!string.equals(this.primTagName)) {
            if (this.isCharacter || this.isPrimitive) {
                String string2 = this.getCharOrPrimString();
                if (string2 != null) {
                    if (string.equals("farClip") && this.farClip == null) {
                        this.farClip = string2;
                    } else if (string.equals("nearClip") && this.nearClip == null) {
                        this.nearClip = string2;
                    } else if (string.equals("fieldOfView") && this.fieldOfView == null) {
                        this.fieldOfView = string2;
                    } else if (string.equals("verticalFieldOfView") && this.verticalFieldOfView == null) {
                        this.verticalFieldOfView = string2;
                    } else {
                        this.processNodeEndElement(string, string2);
                    }
                }
            } else if (string.equals(this.tagName)) {
                this.setNodeProperties((Node)this.currCamera);
                if (this.farClip != null) {
                    this.currCamera.setFarClip(Double.parseDouble(this.farClip));
                }
                if (this.nearClip != null) {
                    this.currCamera.setNearClip(Double.parseDouble(this.nearClip));
                }
                Viewpoint viewpoint = new Viewpoint();
                viewpoint.setFarClip(this.currCamera.getFarClip());
                viewpoint.setName(this.currCamera.getId());
                viewpoint.setNearClip(this.currCamera.getNearClip());
                viewpoint.setPerspectiveProjection(this.isPerspective);
                viewpoint.setTransform(this.getVpTransform(this.camParent, this.currCamera));
                if (this.isPerspective) {
                    if (this.fieldOfView != null) {
                        ((PerspectiveCamera)this.currCamera).setFieldOfView(Double.parseDouble(this.fieldOfView));
                    }
                    if (this.verticalFieldOfView != null) {
                        ((PerspectiveCamera)this.currCamera).setVerticalFieldOfView(Boolean.parseBoolean(this.verticalFieldOfView));
                    }
                    viewpoint.setFieldOfView(((PerspectiveCamera)this.currCamera).getFieldOfView());
                    viewpoint.setVerticalFieldOfView(((PerspectiveCamera)this.currCamera).isVerticalFieldOfView());
                }
                this.fxfp.base.addViewpoint(viewpoint);
                this.fxfp.setParser(this.parentParser);
                this.parentParser = null;
                this.currCamera = null;
                this.camParent = null;
                this.tagName = null;
            }
        }
    }

    private Affine getVpTransform(Group group, Camera camera) {
        Transform transform;
        Object object;
        Affine affine = new Affine();
        if (group != null) {
            object = new ArrayList();
            while (group != null) {
                ((ArrayList)object).add(group);
                group = (Group)group.getParent();
            }
            for (int i = ((ArrayList)object).size() - 1; i >= 0; --i) {
                transform = ((Group)((ArrayList)object).get(i)).getTransforms();
                if (transform == null || transform.size() <= 0) continue;
                for (Transform transform2 : transform) {
                    affine.append(transform2);
                }
            }
        }
        if ((object = camera.getTransforms()) != null && object.size() > 0) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                transform = (Transform)iterator.next();
                affine.append(transform);
            }
        }
        return affine;
    }
}

