/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.fxml;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.fxml.AbstractElementParser;
import com.interactivemesh.jfx.importer.fxml.CylinderParser;
import com.interactivemesh.jfx.importer.fxml.FxFileParser;
import com.interactivemesh.jfx.importer.fxml.GroupParser;
import com.interactivemesh.jfx.importer.fxml.SphereParser;
import javafx.scene.AmbientLight;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.ParallelCamera;
import javafx.scene.PerspectiveCamera;
import javafx.scene.PointLight;
import javafx.scene.shape.Box;
import javafx.scene.shape.MeshView;

final class FxmlRootParser
extends AbstractElementParser {
    private CylinderParser cylinderParser = null;
    private SphereParser sphereParser = null;
    private final GroupParser groupParser = new GroupParser(this.fxfp, true);
    private Node fxmlRoot = null;
    private Group includeParent = null;

    FxmlRootParser(FxFileParser fxFileParser) {
        super(fxFileParser);
    }

    void setup(Group group) {
        this.includeParent = group;
    }

    void clear() {
        this.fxmlRoot = null;
        this.includeParent = null;
    }

    @Override
    void close() {
        this.groupParser.close();
        this.fxmlRoot = null;
    }

    Node getFxmlRoot() {
        if (this.cylinderParser != null) {
            this.fxmlRoot = this.cylinderParser.createCylinder();
            this.cylinderParser = null;
        } else if (this.sphereParser != null) {
            this.fxmlRoot = this.sphereParser.createSphere();
            this.sphereParser = null;
        }
        return this.fxmlRoot;
    }

    @Override
    void startElement(String string) {
        if (string.equals("Group")) {
            this.fxmlRoot = new Group();
            this.groupParser.setup(this, (Group)this.fxmlRoot);
            this.fxfp.setParser(this.groupParser);
        } else if (string.equals("MeshView")) {
            this.fxmlRoot = new MeshView();
            this.fxfp.setMeshViewParser(this, (MeshView)this.fxmlRoot);
        } else if (string.equals("Box")) {
            this.fxmlRoot = new Box();
            this.fxfp.setBoxParser(this, (Box)this.fxmlRoot);
        } else if (string.equals("Cylinder")) {
            this.cylinderParser = this.fxfp.setCylinderParser(this, null);
        } else if (string.equals("Sphere")) {
            this.sphereParser = this.fxfp.setSphereParser(this, null);
        } else if (string.equals("AmbientLight")) {
            if (this.fxfp.base.isIgnoreLights) {
                this.fxfp.setNullParser(this, string);
            } else {
                this.fxmlRoot = new AmbientLight();
                this.fxfp.base.addLight((LightBase)((AmbientLight)this.fxmlRoot));
                this.fxfp.setLightParser(this, (LightBase)((AmbientLight)this.fxmlRoot), string);
            }
        } else if (string.equals("PointLight")) {
            if (this.fxfp.base.isIgnoreLights) {
                this.fxfp.setNullParser(this, string);
            } else {
                this.fxmlRoot = new PointLight();
                this.fxfp.base.addLight((LightBase)((PointLight)this.fxmlRoot));
                this.fxfp.setLightParser(this, (LightBase)((PointLight)this.fxmlRoot), string);
            }
        } else if (string.equals("ParallelCamera")) {
            ParallelCamera parallelCamera = new ParallelCamera();
            if (!this.fxfp.base.isIgnoreCameras) {
                this.fxmlRoot = parallelCamera;
                this.fxfp.base.addCamera((Camera)parallelCamera);
            }
            this.fxfp.setCameraParser(this, (Camera)parallelCamera, string, this.includeParent);
        } else if (string.equals("PerspectiveCamera")) {
            PerspectiveCamera perspectiveCamera = new PerspectiveCamera(true);
            if (!this.fxfp.base.isIgnoreCameras) {
                this.fxmlRoot = perspectiveCamera;
                this.fxfp.base.addCamera((Camera)perspectiveCamera);
            }
            this.fxfp.setCameraParser(this, (Camera)perspectiveCamera, string, this.includeParent);
        } else {
            throw new ImportException("FxmlRootParser: root not supported = " + string);
        }
    }

    @Override
    void endElement(String string) {
    }
}

