/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.fxml;

import com.interactivemesh.jfx.importer.fxml.AbstractElementParser;
import com.interactivemesh.jfx.importer.fxml.AbstractElementParserChar;
import com.interactivemesh.jfx.importer.fxml.FxFileParser;
import com.interactivemesh.jfx.importer.fxml.MeshSmoother;
import com.interactivemesh.jfx.importer.fxml.Normalizer;
import java.util.ArrayList;
import javafx.scene.shape.TriangleMesh;

final class TriangleMeshParser
extends AbstractElementParserChar {
    private AbstractElementParser parentParser;
    private TriangleMesh currTriaMesh = null;
    private boolean isA = true;
    private Normalizer normalizer = null;
    private MeshSmoother smoother = null;

    TriangleMeshParser(FxFileParser fxFileParser) {
        super(fxFileParser);
        this.charArray = new char[6000000];
    }

    void setup(AbstractElementParser abstractElementParser, TriangleMesh triangleMesh) {
        this.parentParser = abstractElementParser;
        this.currTriaMesh = triangleMesh;
        this.setupChar();
        String string = this.fxfp.xR.getAttributeValue("http://javafx.com/fxml", "id");
        if (string != null) {
            this.fxfp.currCache.putTriangleMesh(string, this.currTriaMesh);
        }
    }

    @Override
    void close() {
        this.charArray = null;
        if (this.smoother != null) {
            this.smoother.close();
            this.smoother = null;
            this.normalizer = null;
        }
    }

    @Override
    void startElement(String string) {
        this.isCharacter = false;
        if (string.equals("points")) {
            this.isCharacter = true;
        } else if (string.equals("texCoords")) {
            this.isCharacter = true;
        } else if (string.equals("faces")) {
            this.isCharacter = true;
        } else if (string.equals("faceSmoothingGroups")) {
            this.isCharacter = true;
        } else {
            this.fxfp.setNullParser(this, string);
        }
        if (this.isCharacter) {
            this.arrPos = 0;
        }
    }

    @Override
    void endElement(String string) {
        if (this.isCharacter && this.arrPos > 0) {
            this.isCharacter = false;
            if (string.equals("points")) {
                int n = 0;
                n = this.isA ? this.fxfp.base.fxUtils.splitFloatsC(this.charArray, this.arrPos) : this.fxfp.base.fxUtils.splitFloatsD(this.charArray, this.arrPos);
                this.isA = !this.isA;
                this.currTriaMesh.getPoints().setAll(this.fxfp.base.fxUtils.getFloatValues(), 0, n);
            } else if (string.equals("texCoords")) {
                int n = 0;
                n = this.isA ? this.fxfp.base.fxUtils.splitFloatsC(this.charArray, this.arrPos) : this.fxfp.base.fxUtils.splitFloatsD(this.charArray, this.arrPos);
                this.isA = !this.isA;
                this.currTriaMesh.getTexCoords().setAll(this.fxfp.base.fxUtils.getFloatValues(), 0, n);
            } else if (string.equals("faces")) {
                int n = this.fxfp.base.fxUtils.splitIntegers(this.charArray, this.arrPos);
                this.currTriaMesh.getFaces().setAll(this.fxfp.base.fxUtils.getIntValues(), 0, n);
            } else if (string.equals("faceSmoothingGroups") && !this.fxfp.base.isGenerateNormals) {
                int n = this.fxfp.base.fxUtils.splitIntegers(this.charArray, this.arrPos);
                this.currTriaMesh.getFaceSmoothingGroups().setAll(this.fxfp.base.fxUtils.getIntValues(), 0, n);
            }
        } else if (string.equals("TriangleMesh")) {
            int n;
            int n2;
            int n3;
            int n4;
            if (this.fxfp.base.isReverse) {
                n4 = this.currTriaMesh.getFaceElementSize();
                int n5 = this.currTriaMesh.getFaces().size();
                n3 = n5 / n4;
                int[] nArray = new int[n5];
                this.currTriaMesh.getFaces().toArray(nArray);
                n2 = 0;
                int n6 = 0;
                for (n = 0; n < n5; n += n4) {
                    n2 = nArray[n + 4];
                    n6 = nArray[n + 5];
                    nArray[n + 4] = nArray[n + 2];
                    nArray[n + 5] = nArray[n + 3];
                    nArray[n + 2] = n2;
                    nArray[n + 3] = n6;
                }
                this.currTriaMesh.getFaces().setAll(nArray);
            }
            if (this.fxfp.base.isGenerateNormals) {
                if (this.normalizer == null) {
                    this.normalizer = new Normalizer();
                }
                if (this.smoother == null) {
                    this.smoother = new MeshSmoother();
                }
                n4 = this.currTriaMesh.getPoints().size();
                float[] fArray = new float[n4];
                this.currTriaMesh.getPoints().toArray(fArray);
                n3 = this.currTriaMesh.getFaceElementSize();
                int n7 = this.currTriaMesh.getFaces().size();
                n2 = n7 / n3;
                int[] nArray = new int[n7];
                this.currTriaMesh.getFaces().toArray(nArray);
                n = n2 * 3;
                int[] nArray2 = new int[n];
                int n8 = 0;
                for (int i = 0; i < n7; i += 2) {
                    nArray2[n8++] = nArray[i];
                }
                int[] nArray3 = new int[n4 / 3];
                float[] fArray2 = this.normalizer.calcTriangleNormals(fArray, nArray2, nArray3);
                int[][] nArray4 = this.normalizer.vertexIndices(nArray2, nArray3);
                int[] nArray5 = new int[n];
                this.normalizer.calcIndexedVertexNormals(this.fxfp.base.creaseAngle, true, fArray2, nArray2, nArray4, nArray5);
                ArrayList<MeshSmoother.SmoothMesh> arrayList = this.smoother.create(nArray2, fArray.length / 3, nArray5);
                int[] nArray6 = new int[n2];
                ArrayList<Integer> arrayList2 = null;
                int n9 = 0;
                for (MeshSmoother.SmoothMesh smoothMesh : arrayList) {
                    arrayList2 = smoothMesh.getIndices();
                    n9 = smoothMesh.getSmGrId();
                    int n10 = arrayList2.size();
                    for (int i = 0; i < n10; i += 3) {
                        nArray6[arrayList2.get((int)i).intValue() / 3] = n9;
                    }
                    smoothMesh.close();
                }
                arrayList.clear();
                this.currTriaMesh.getFaceSmoothingGroups().setAll(nArray6);
            }
            this.fxfp.setParser(this.parentParser);
            this.parentParser = null;
            this.currTriaMesh = null;
        }
    }
}

