/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.AbstractElementParser;
import com.interactivemesh.jfx.importer.col.AbstractElementParserChar;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.CVersion;
import com.interactivemesh.jfx.importer.col.ColAsset;
import com.interactivemesh.jfx.importer.col.ColladaFileParser;

final class AssetParser
extends AbstractElementParserChar {
    private AbstractElementParser parentParser = null;
    private Asset asset = null;
    private Asset.Contributor currContributor = null;
    private Asset.GeographicLocation currGeoLocation = null;
    private boolean isContributorElement = false;
    private boolean isGeoLocation = false;

    AssetParser(ColladaFileParser colladaFileParser) {
        super(colladaFileParser);
        this.charArray = new char[200];
        this.isCharacter = true;
    }

    void setup(AbstractElementParser abstractElementParser, Asset asset) {
        this.parentParser = abstractElementParser;
        this.asset = asset;
        this.arrPos = 0;
    }

    @Override
    void doClose() {
        this.charArray = null;
    }

    @Override
    void startElement(String string) {
        this.arrPos = 0;
        if (this.isGeoLocation) {
            String string2;
            if (string.equals("altitude") && (string2 = this.cfp.xR.getAttributeValue(null, "mode")) != null) {
                this.currGeoLocation.altitudeMode = string2;
            }
        } else if (string.equals("contributor")) {
            this.isContributorElement = true;
            this.currContributor = new Asset.Contributor();
            this.asset.contributorList.add(this.currContributor);
        } else if (string.equals("unit")) {
            String string3 = this.cfp.xR.getAttributeValue(null, "meter");
            if (string3 != null && string3.length() > 0) {
                this.asset.unitMeter = Float.parseFloat(string3);
            }
            this.asset.unitName = this.cfp.xR.getAttributeValue(null, "name");
        } else if (this.cfp.currFileVersion == CVersion.ONE_FIVE_ZERO) {
            if (string.equals("geographic_location")) {
                this.isGeoLocation = true;
                this.asset.geoLocation = this.currGeoLocation = new Asset.GeographicLocation();
            } else if (string.equals("extra")) {
                this.cfp.setNullParser(this, string);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void endElement(String string) {
        if (string.equals("contributor")) {
            this.isContributorElement = false;
            return;
        }
        if (string.equals("geographic_location")) {
            this.isGeoLocation = false;
            return;
        }
        if (string.equals("asset")) {
            this.cfp.setParser(this.parentParser);
            this.parentParser = null;
            this.asset = null;
            this.currContributor = null;
            this.currGeoLocation = null;
            this.isContributorElement = false;
            return;
        }
        String string2 = this.cUtils().trimString(this.charArray, this.arrPos);
        if (this.isContributorElement) {
            if (string.equals("author")) {
                this.currContributor.author = string2;
                return;
            }
            if (string.equals("authoring_tool")) {
                this.currContributor.atool = string2;
                return;
            }
            if (string.equals("comments")) {
                this.currContributor.comments = string2;
                return;
            }
            if (string.equals("copyright")) {
                this.currContributor.copyright = string2;
                return;
            }
            if (string.equals("source_data")) {
                this.currContributor.source = string2;
                return;
            }
            if (string.equals("author_email")) {
                this.currContributor.authorMail = string2;
                return;
            }
            if (!string.equals("author_website")) throw new IllegalStateException("AssetParser endElement 1 name =" + string + "-");
            this.currContributor.authorWeb = string2;
            return;
        }
        if (this.isGeoLocation) {
            if (string.equals("longitude")) {
                this.currGeoLocation.longitude = Float.parseFloat(string2);
                return;
            }
            if (string.equals("latitude")) {
                this.currGeoLocation.latitude = Float.parseFloat(string2);
                return;
            }
            if (!string.equals("altitude")) return;
            this.currGeoLocation.altitudeValue = Float.parseFloat(string2);
            return;
        }
        if (string.equals("created")) {
            this.asset.created = string2;
            return;
        }
        if (string.equals("keywords")) {
            this.asset.keywords = string2;
            return;
        }
        if (string.equals("modified")) {
            this.asset.modified = string2;
            return;
        }
        if (string.equals("revision")) {
            this.asset.revision = string2;
            return;
        }
        if (string.equals("subject")) {
            this.asset.subject = string2;
            return;
        }
        if (string.equals("title")) {
            this.asset.title = string2;
            return;
        }
        if (!string.equals("up_axis")) {
            if (!string.equals("unit")) return;
            return;
        }
        String string3 = string2;
        if (string3.endsWith("X_UP")) {
            this.asset.upAxis = ColAsset.UpAxis.X_UP;
            return;
        }
        if (string3.endsWith("Z_UP")) {
            this.asset.upAxis = ColAsset.UpAxis.Z_UP;
            return;
        }
        if (string3.endsWith("Y_UP")) {
            this.asset.upAxis = ColAsset.UpAxis.Y_UP;
            return;
        }
        if (string3 == null) return;
        if (string3.length() <= 0) return;
        throw new IllegalStateException("AssetParser endElement 3 name =" + string + "-" + string3);
    }
}

