/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.Viewpoint;
import com.interactivemesh.jfx.importer.col.AbstractIdElement;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.ElementBase;
import com.interactivemesh.jfx.importer.col.ElementCache;
import javafx.geometry.Point3D;
import javafx.scene.Camera;
import javafx.scene.Node;
import javafx.scene.ParallelCamera;
import javafx.scene.PerspectiveCamera;
import javafx.scene.transform.Affine;

final class CameraC
extends AbstractIdElement {
    String name = null;
    Asset asset = null;
    float xMag = Float.NEGATIVE_INFINITY;
    float yMag = Float.NEGATIVE_INFINITY;
    String xMagSID = null;
    String yMagSID = null;
    float xFov = Float.NEGATIVE_INFINITY;
    float yFov = Float.NEGATIVE_INFINITY;
    String xFovSID = null;
    String yFovSID = null;
    float aspectRatio = Float.NEGATIVE_INFINITY;
    float zNear = Float.NEGATIVE_INFINITY;
    float zFar = Float.NEGATIVE_INFINITY;
    String aspectRatioSID = null;
    String zNearSID = null;
    String zFarSID = null;
    boolean isPerspective = true;

    CameraC() {
    }

    @Override
    void initialize(ElementBase elementBase, ElementCache elementCache) {
        super.initialize(elementBase, elementCache);
        if (this.id != null) {
            elementCache.putCamera(this.id, this);
        }
        if (this.asset != null) {
            this.asset.initialize(elementBase, elementCache);
        }
    }

    Camera getCamera(String string) {
        ParallelCamera parallelCamera = null;
        if (this.isPerspective) {
            parallelCamera = new PerspectiveCamera(true);
            if (this.yFov != Float.NEGATIVE_INFINITY) {
                ((PerspectiveCamera)parallelCamera).setFieldOfView((double)this.yFov);
            } else if (this.xFov != Float.NEGATIVE_INFINITY) {
                ((PerspectiveCamera)parallelCamera).setFieldOfView((double)this.xFov);
                ((PerspectiveCamera)parallelCamera).setVerticalFieldOfView(false);
            }
        } else {
            parallelCamera = new ParallelCamera();
        }
        if (this.zNear != Float.NEGATIVE_INFINITY) {
            parallelCamera.setNearClip((double)this.zNear);
        }
        if (this.zFar != Float.NEGATIVE_INFINITY) {
            parallelCamera.setFarClip((double)this.zFar);
        }
        String string2 = this.getCameraName(string);
        parallelCamera.setId(string2);
        this.base.putNamedNode(string2, (Node)parallelCamera);
        return parallelCamera;
    }

    String getCameraName(String string) {
        String string2 = null;
        string2 = string != null && string.length() > 0 ? string : (this.name != null && this.name.length() > 0 ? this.name : (this.id != null && this.id.length() > 0 ? this.id : (this.isPerspective ? "PerspectiveCamera" : "ParallelCamera")));
        string2 = this.base.createUniqueName(string2);
        return string2;
    }

    void createViewpointFromCamera(Affine affine, String string) {
        Viewpoint viewpoint = new Viewpoint();
        viewpoint.setName(string);
        if (this.zNear != Float.NEGATIVE_INFINITY) {
            viewpoint.setNearClip(this.zNear);
        }
        if (this.zFar != Float.NEGATIVE_INFINITY) {
            viewpoint.setFarClip(this.zFar);
        }
        viewpoint.setTransform(affine);
        double d = Math.acos((affine.getMxx() + affine.getMyy() + affine.getMzz() - 1.0) / 2.0);
        double d2 = Math.toDegrees(d);
        double d3 = affine.getMzy() - affine.getMyz();
        double d4 = affine.getMxz() - affine.getMzx();
        double d5 = affine.getMyx() - affine.getMxy();
        if (d2 == 0.0) {
            d3 = 0.0;
            d4 = -1.0;
            d5 = 0.0;
        }
        Point3D point3D = new Point3D(d3, d4, d5).normalize();
        if (this.isPerspective) {
            viewpoint.setPerspectiveProjection(true);
            if (this.yFov != Float.NEGATIVE_INFINITY) {
                viewpoint.setFieldOfView(this.yFov);
            } else if (this.xFov != Float.NEGATIVE_INFINITY) {
                viewpoint.setFieldOfView(this.xFov);
                viewpoint.setVerticalFieldOfView(false);
            }
        } else {
            viewpoint.setPerspectiveProjection(false);
        }
        this.base.addViewpoint(viewpoint);
    }
}

