/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.FilePath;
import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.col.AbstractIdElement;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.CVersion;
import com.interactivemesh.jfx.importer.col.ElementBase;
import com.interactivemesh.jfx.importer.col.ElementCache;
import com.interactivemesh.jfx.importer.col.SID;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javafx.scene.image.Image;
import javax.xml.stream.XMLStreamReader;

final class ImageC
extends AbstractIdElement
implements SID {
    String name = null;
    String format = null;
    int height = 0;
    int width = 0;
    int depth = 1;
    String initFrom = null;
    Asset asset = null;
    String sid = null;
    private Image image = null;

    @Override
    public String getSID() {
        return this.sid;
    }

    ImageC() {
    }

    @Override
    void initialize(ElementBase elementBase, ElementCache elementCache) {
        super.initialize(elementBase, elementCache);
        if (this.id != null) {
            elementCache.putImage(this.id, this);
        }
        if (this.asset != null) {
            this.asset.initialize(elementBase, elementCache);
        }
    }

    @Override
    void clear() {
        this.image = null;
        super.clear();
    }

    void getAttributes(XMLStreamReader xMLStreamReader, CVersion cVersion) {
        this.id = xMLStreamReader.getAttributeValue(null, "id");
        this.name = xMLStreamReader.getAttributeValue(null, "name");
        if (cVersion == CVersion.ONE_FOUR_ONE) {
            this.format = xMLStreamReader.getAttributeValue(null, "format");
            String string = xMLStreamReader.getAttributeValue(null, "height");
            if (string != null) {
                this.height = Integer.parseInt(string);
            }
            if ((string = xMLStreamReader.getAttributeValue(null, "width")) != null) {
                this.width = Integer.parseInt(string);
            }
            if ((string = xMLStreamReader.getAttributeValue(null, "depth")) != null) {
                this.depth = Integer.parseInt(string);
            }
        } else if (cVersion == CVersion.ONE_FIVE_ZERO) {
            this.sid = xMLStreamReader.getAttributeValue(null, "sid");
        }
    }

    Image getImage() {
        if (this.image == null) {
            if (this.initFrom == null || this.initFrom.length() < 1) {
                throw new ImportException("Can't create image: init_from is null!");
            }
            String string = this.initFrom.replace('\\', '/');
            int n = string.lastIndexOf(46) + 1;
            String string2 = string.substring(n);
            URL uRL = this.base.cUtils.getUrlForAbsolutPath(string);
            if (uRL != null || this.base.zaeCache == null) {
                if (uRL == null) {
                    uRL = this.base.cUtils.getUrlForRelativePath(this.cache.getBaseURL(), string);
                }
                if (uRL == null) {
                    throw new ImportException("Can't create URL for image from path = \n" + string);
                }
                try {
                    if (string2.equalsIgnoreCase("tga") || string2.equalsIgnoreCase("tif") || string2.equalsIgnoreCase("tiff")) {
                        this.image = this.base.imgFactory.readImage(string2, uRL);
                    } else {
                        if (this.base.isWritableImage) {
                            this.image = this.base.imgFactory.readImage(string2, uRL);
                        }
                        if (this.image == null) {
                            this.image = new Image(uRL.toExternalForm());
                        }
                        if (this.image == null) {
                            this.image = this.base.imgFactory.readImage(string2, uRL);
                        }
                    }
                    this.cache.putImagePath(this.image, new FilePath(string, uRL));
                }
                catch (IOException iOException) {
                    throw new ImportException("Can't create image for URL = \n" + uRL.toString() + "\n" + iOException.getMessage(), iOException);
                }
            } else if (this.base.zaeCache != null) {
                try {
                    String string3 = this.cache.getZaeEntryBase();
                    String string4 = this.base.zaeCache.normalizeZaeEntry(string3, string);
                    InputStream inputStream = this.base.zaeCache.getInputStreamForEntry(string4);
                    if (string2.equalsIgnoreCase("tga") || string2.equalsIgnoreCase("tif") || string2.equalsIgnoreCase("tiff")) {
                        this.image = this.base.imgFactory.readImage(string2, inputStream);
                    } else {
                        if (this.base.isWritableImage) {
                            this.image = this.base.imgFactory.readImage(string2, inputStream);
                        }
                        if (this.image == null) {
                            this.image = new Image(inputStream);
                        }
                        if (this.image == null) {
                            this.image = this.base.imgFactory.readImage(string2, inputStream);
                        }
                    }
                    this.cache.putImagePath(this.image, new FilePath(string, null));
                }
                catch (IOException iOException) {
                    throw new ImportException("Can't create image for entry >" + this.initFrom + "<\n", iOException);
                }
            } else {
                throw new ImportException("Can't create URL for image from path = \n" + string);
            }
        }
        return this.image;
    }
}

