/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.AbstractElementParserChar;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.COLLADAParser;
import com.interactivemesh.jfx.importer.col.CameraC;
import com.interactivemesh.jfx.importer.col.LibCameras;

final class LibCamerasParser
extends AbstractElementParserChar {
    private COLLADAParser colladaParser = null;
    private LibCameras libCameras = null;
    private boolean isCamera = false;
    private CameraC currCamera = null;
    private boolean isOptics = false;
    private boolean isOrthographic = false;
    private boolean isPerspective = false;

    LibCamerasParser(COLLADAParser cOLLADAParser, LibCameras libCameras) {
        super(cOLLADAParser.cfp);
        this.colladaParser = cOLLADAParser;
        this.libCameras = libCameras;
        this.charArray = new char[200];
    }

    void setup(LibCameras libCameras) {
        this.libCameras = libCameras;
        this.arrPos = 0;
        this.isCharacter = false;
    }

    @Override
    void doClose() {
        this.colladaParser = null;
        this.charArray = null;
    }

    @Override
    void startElement(String string) {
        if (this.isCamera) {
            if (this.isOptics) {
                if (this.isOrthographic || this.isPerspective) {
                    if (string.equals("aspect_ratio")) {
                        this.currCamera.aspectRatioSID = this.cfp.xR.getAttributeValue(null, "sid");
                        this.isCharacter = true;
                    } else if (string.equals("znear")) {
                        this.currCamera.zNearSID = this.cfp.xR.getAttributeValue(null, "sid");
                        this.isCharacter = true;
                    } else if (string.equals("zfar")) {
                        this.currCamera.zFarSID = this.cfp.xR.getAttributeValue(null, "sid");
                        this.isCharacter = true;
                    }
                    if (this.isOrthographic) {
                        if (string.equals("xmag")) {
                            this.currCamera.xMagSID = this.cfp.xR.getAttributeValue(null, "sid");
                            this.isCharacter = true;
                        } else if (string.equals("ymag")) {
                            this.currCamera.yMagSID = this.cfp.xR.getAttributeValue(null, "sid");
                            this.isCharacter = true;
                        } else if (string.equals("extra")) {
                            this.cfp.setNullParser(this, string);
                        }
                    } else if (this.isPerspective) {
                        if (string.equals("xfov")) {
                            this.currCamera.xFovSID = this.cfp.xR.getAttributeValue(null, "sid");
                            this.isCharacter = true;
                        } else if (string.equals("yfov")) {
                            this.currCamera.yFovSID = this.cfp.xR.getAttributeValue(null, "sid");
                            this.isCharacter = true;
                        }
                    }
                    this.arrPos = 0;
                } else if (string.equals("orthographic")) {
                    this.currCamera.isPerspective = false;
                    this.isOrthographic = true;
                } else if (string.equals("perspective")) {
                    this.currCamera.isPerspective = true;
                    this.isPerspective = true;
                } else if (string.equals("technique")) {
                    System.out.println("LibCamerasParser Camera : technique not supported, profil = " + this.cfp.xR.getAttributeValue(null, "profile"));
                    this.cfp.setNullParser(this, string);
                } else if (string.equals("extra")) {
                    this.cfp.setNullParser(this, string);
                }
            } else if (string.equals("optics")) {
                this.isOptics = true;
            } else if (string.equals("imager")) {
                this.cfp.setNullParser(this, string);
            } else if (string.equals("asset")) {
                Asset asset;
                this.currCamera.asset = asset = new Asset();
                this.cfp.setAssetParser(this, asset);
            } else if (string.equals("extra")) {
                this.cfp.setNullParser(this, string);
            }
        } else if (string.equals("camera")) {
            this.currCamera = new CameraC();
            this.currCamera.id = this.cfp.xR.getAttributeValue(null, "id");
            this.currCamera.name = this.cfp.xR.getAttributeValue(null, "name");
            this.libCameras.addCamera(this.currCamera);
            this.isCamera = true;
        } else if (string.equals("asset")) {
            Asset asset;
            this.libCameras.asset = asset = new Asset();
            this.cfp.setAssetParser(this, asset);
        } else if (string.equals("extra")) {
            this.cfp.setNullParser(this, string);
        }
    }

    @Override
    void endElement(String string) {
        if ((this.isOrthographic || this.isPerspective) && this.isCharacter) {
            float f = Float.parseFloat(this.cUtils().trimString(this.charArray, this.arrPos));
            if (string.equals("aspect_ratio")) {
                this.currCamera.aspectRatio = f;
            } else if (string.equals("znear")) {
                this.currCamera.zNear = f;
            } else if (string.equals("zfar")) {
                this.currCamera.zFar = f;
            } else if (string.equals("xmag")) {
                this.currCamera.xMag = f;
            } else if (string.equals("ymag")) {
                this.currCamera.yMag = f;
            } else if (string.equals("xfov")) {
                this.currCamera.xFov = f;
            } else if (string.equals("yfov")) {
                this.currCamera.yFov = f;
            }
            this.isCharacter = false;
        } else if (string.equals("perspective")) {
            this.isPerspective = false;
        } else if (string.equals("orthographic")) {
            this.isOrthographic = false;
        } else if (string.equals("optics")) {
            this.isOptics = false;
        } else if (string.equals("camera")) {
            this.currCamera = null;
            this.isCamera = false;
        } else if (string.equals("library_cameras")) {
            this.cfp.setParser(this.colladaParser);
            this.libCameras = null;
        }
    }
}

