/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.AbstractElementParserChar;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.COLLADAParser;
import com.interactivemesh.jfx.importer.col.Controller;
import com.interactivemesh.jfx.importer.col.InputS;
import com.interactivemesh.jfx.importer.col.InputU;
import com.interactivemesh.jfx.importer.col.LibControllers;
import com.interactivemesh.jfx.importer.col.Source;
import java.util.ArrayList;

final class LibControllersParser
extends AbstractElementParserChar {
    private COLLADAParser colladaParser = null;
    private LibControllers libControllers = null;
    private boolean isController = false;
    private Controller currContrl = null;
    private boolean isMorph = false;
    private boolean isMorphTargets = false;
    private Controller.Morph currMorph = null;
    private boolean isSkin = false;
    private boolean isSkinJoints = false;
    private boolean isSkinVertWghts = false;
    private Controller.Skin currSkin = null;

    LibControllersParser(COLLADAParser cOLLADAParser, LibControllers libControllers) {
        super(cOLLADAParser.cfp);
        this.colladaParser = cOLLADAParser;
        this.libControllers = libControllers;
        this.charArray = new char[200];
    }

    void setup(LibControllers libControllers) {
        this.libControllers = libControllers;
        this.arrPos = 0;
        this.isCharacter = false;
    }

    @Override
    void doClose() {
        this.colladaParser = null;
        this.charArray = null;
    }

    @Override
    void startElement(String string) {
        if (this.isController) {
            if (this.isMorph) {
                if (this.isMorphTargets) {
                    if (string.equals("input")) {
                        InputU inputU = new InputU();
                        inputU.semantic = this.cfp.xR.getAttributeValue(null, "semantic");
                        inputU.source = this.cfp.xR.getAttributeValue(null, "source");
                        if (inputU.semantic.equals("MORPH_TARGET")) {
                            this.currMorph.targetInput = inputU;
                        } else if (inputU.semantic.equals("MORPH_WEIGHT")) {
                            this.currMorph.weightInput = inputU;
                        } else {
                            System.out.println("LibControllersParser isMorphTargets unknown semantic = " + inputU.semantic);
                        }
                    } else if (string.equals("extra")) {
                        this.cfp.setNullParser(this, string);
                    }
                } else if (string.equals("source")) {
                    Source source = new Source();
                    source.id = this.cfp.xR.getAttributeValue(null, "id");
                    source.name = this.cfp.xR.getAttributeValue(null, "name");
                    this.libControllers.addSource(source);
                    this.cfp.setSourceParser(this, source);
                } else if (string.equals("targets")) {
                    this.isMorphTargets = true;
                } else if (string.equals("extra")) {
                    this.cfp.setNullParser(this, string);
                }
            } else if (this.isSkin) {
                if (this.isSkinJoints) {
                    if (string.equals("input")) {
                        InputU inputU = new InputU();
                        inputU.semantic = this.cfp.xR.getAttributeValue(null, "semantic");
                        inputU.source = this.cfp.xR.getAttributeValue(null, "source");
                        if (inputU.semantic.equals("JOINT")) {
                            this.currSkin.jJointInput = inputU;
                        } else if (inputU.semantic.equals("INV_BIND_MATRIX")) {
                            this.currSkin.jInvBindMatrixInput = inputU;
                        } else {
                            System.out.println("LibControllersParser isSkinJoints unknown semantic = " + inputU.semantic);
                        }
                    } else if (string.equals("extra")) {
                        this.cfp.setNullParser(this, string);
                    }
                } else if (this.isSkinVertWghts) {
                    if (string.equals("input")) {
                        InputS inputS = new InputS();
                        inputS.semantic = this.cfp.xR.getAttributeValue(null, "semantic");
                        inputS.source = this.cfp.xR.getAttributeValue(null, "source");
                        String string2 = this.cfp.xR.getAttributeValue(null, "offset");
                        if (string2 != null) {
                            inputS.offset = Integer.parseInt(string2);
                        }
                        if ((string2 = this.cfp.xR.getAttributeValue(null, "set")) != null) {
                            inputS.set = Integer.parseInt(string2);
                        }
                        if (inputS.semantic.equals("JOINT")) {
                            this.currSkin.vwJointInput = inputS;
                        } else if (inputS.semantic.equals("WEIGHT")) {
                            this.currSkin.vwWeightInput = inputS;
                        } else {
                            System.out.println("LibControllersParser isSkinVertWghts unknown semantic = " + inputS.semantic);
                        }
                    } else if (string.equals("vcount")) {
                        this.isCharacter = true;
                        this.arrPos = 0;
                    } else if (string.equals("v")) {
                        this.isCharacter = true;
                        this.arrPos = 0;
                    } else if (string.equals("extra")) {
                        this.cfp.setNullParser(this, string);
                    }
                } else if (string.equals("bind_shape_matrix")) {
                    this.isCharacter = true;
                    this.arrPos = 0;
                } else if (string.equals("source")) {
                    Source source = new Source();
                    source.id = this.cfp.xR.getAttributeValue(null, "id");
                    source.name = this.cfp.xR.getAttributeValue(null, "name");
                    this.libControllers.addSource(source);
                    this.cfp.setSourceParser(this, source);
                } else if (string.equals("joints")) {
                    this.isSkinJoints = true;
                } else if (string.equals("vertex_weights")) {
                    String string3 = this.cfp.xR.getAttributeValue(null, "count");
                    if (string3 != null) {
                        this.currSkin.vertexWeightCounts = Integer.parseInt(string3);
                    }
                    this.isSkinVertWghts = true;
                } else if (string.equals("extra")) {
                    this.cfp.setNullParser(this, string);
                }
            } else if (string.equals("morph")) {
                this.currMorph = this.currContrl.createMorph(this.cfp.xR.getAttributeValue(null, "source"), this.cfp.xR.getAttributeValue(null, "method"));
                this.isMorph = true;
            } else if (string.equals("skin")) {
                this.currSkin = this.currContrl.createSkin(this.cfp.xR.getAttributeValue(null, "source"));
                this.isSkin = true;
            } else if (string.equals("asset")) {
                Asset asset;
                this.currContrl.asset = asset = new Asset();
                this.cfp.setAssetParser(this, asset);
            } else if (string.equals("extra")) {
                this.cfp.setNullParser(this, string);
            }
        } else if (string.equals("controller")) {
            this.currContrl = new Controller();
            this.currContrl.id = this.cfp.xR.getAttributeValue(null, "id");
            this.currContrl.name = this.cfp.xR.getAttributeValue(null, "name");
            this.libControllers.addController(this.currContrl);
            this.isController = true;
        } else if (string.equals("asset")) {
            Asset asset;
            this.libControllers.asset = asset = new Asset();
            this.cfp.setAssetParser(this, asset);
        } else if (string.equals("extra")) {
            this.cfp.setNullParser(this, string);
        }
    }

    @Override
    void endElement(String string) {
        if (this.isMorph) {
            if (string.equals("targets")) {
                this.isMorphTargets = false;
            } else if (string.equals("morph")) {
                this.currMorph = null;
                this.isMorph = false;
            }
        } else if (this.isSkin) {
            if (string.equals("bind_shape_matrix")) {
                String string2 = this.cUtils().trimString(this.charArray, this.arrPos);
                float[] fArray = new float[16];
                this.cUtils().splitFloatInto(string2, fArray);
                this.currSkin.bindShapeMatrix = fArray;
                this.isCharacter = false;
            } else if (string.equals("joints")) {
                this.isSkinJoints = false;
            } else if (string.equals("vertex_weights")) {
                this.isSkinVertWghts = false;
            } else if (string.equals("vcount")) {
                if (this.currSkin.vertexWeightCounts > 0) {
                    int[] nArray = new int[this.currSkin.vertexWeightCounts];
                    this.cUtils().splitIntegerInto(this.charArray, this.arrPos, nArray);
                    this.currSkin.vcounts = nArray;
                }
                this.isCharacter = false;
            } else if (string.equals("v")) {
                try {
                    if (this.currSkin.vcounts != null) {
                        String string3 = this.cUtils().trimString(this.charArray, this.arrPos);
                        ArrayList<String> arrayList = this.cUtils().splitString(string3);
                        int[] nArray = this.currSkin.vcounts;
                        int n = 0;
                        for (int n2 : nArray) {
                            n += nArray[n2];
                        }
                        n *= 2;
                        int[] nArray2 = new int[arrayList.size()];
                        this.cUtils().splitPosNegIntsInto(this.charArray, this.arrPos, nArray2);
                        this.currSkin.vs = nArray2;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.isCharacter = false;
            } else if (string.equals("skin")) {
                this.currSkin = null;
                this.isSkin = false;
            }
        } else if (string.equals("controller")) {
            this.currContrl = null;
            this.isController = false;
        } else if (string.equals("library_controllers")) {
            this.cfp.setParser(this.colladaParser);
            this.libControllers = null;
        }
    }
}

