/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.AbstractElementParser;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.COLLADAParser;
import com.interactivemesh.jfx.importer.col.Geometry;
import com.interactivemesh.jfx.importer.col.LibGeometries;
import com.interactivemesh.jfx.importer.col.Mesh;
import com.interactivemesh.jfx.importer.col.MeshParser;

final class LibGeometriesParser
extends AbstractElementParser {
    private COLLADAParser colladaParser = null;
    private LibGeometries libGeoms = null;
    private MeshParser meshParser = null;
    private boolean isGeometry = false;
    private Geometry currGeom = null;

    LibGeometriesParser(COLLADAParser cOLLADAParser, LibGeometries libGeometries) {
        super(cOLLADAParser.cfp);
        this.colladaParser = cOLLADAParser;
        this.libGeoms = libGeometries;
    }

    void setup(LibGeometries libGeometries) {
        this.libGeoms = libGeometries;
    }

    @Override
    void doClose() {
        if (this.meshParser != null) {
            this.meshParser.close();
            this.meshParser = null;
        }
        this.colladaParser = null;
    }

    @Override
    void startElement(String string) {
        if (this.isGeometry) {
            if (string.equals("mesh")) {
                Mesh mesh;
                this.libGeoms.addGeomMesh(this.currGeom);
                this.currGeom.mesh = mesh = new Mesh();
                if (this.meshParser == null) {
                    this.meshParser = new MeshParser(this);
                }
                this.meshParser.setup(mesh);
                this.cfp.setParser(this.meshParser);
            } else if (string.equals("convex_mesh")) {
                this.cfp.setNullParser(this, string);
                System.out.println("LibGeometriesParser : convex_mesh is not supported !");
            } else if (string.equals("spline")) {
                this.cfp.setNullParser(this, string);
                System.out.println("LibGeometriesParser : spline is not supported !");
            } else if (string.equals("brep")) {
                this.cfp.setNullParser(this, string);
                System.out.println("LibGeometriesParser : brep is not supported !");
            } else if (string.equals("asset")) {
                Asset asset;
                this.libGeoms.asset = asset = new Asset();
                this.cfp.setAssetParser(this, asset);
            } else if (string.equals("extra")) {
                this.cfp.setNullParser(this, string);
            }
        } else if (string.equals("geometry")) {
            this.isGeometry = true;
            this.currGeom = new Geometry();
            this.currGeom.id = this.cfp.xR.getAttributeValue(null, "id");
            this.currGeom.name = this.cfp.xR.getAttributeValue(null, "name");
        } else if (string.equals("asset")) {
            Asset asset;
            this.libGeoms.asset = asset = new Asset();
            this.cfp.setAssetParser(this, asset);
        } else if (string.equals("extra")) {
            this.cfp.setNullParser(this, string);
        }
    }

    @Override
    void endElement(String string) {
        if (string.equals("geometry")) {
            this.isGeometry = false;
        } else if (string.equals("library_geometries")) {
            this.cfp.setParser(this.colladaParser);
            this.libGeoms = null;
        }
    }
}

