/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.AbstractElementParserChar;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.COLLADAParser;
import com.interactivemesh.jfx.importer.col.LibLights;
import com.interactivemesh.jfx.importer.col.LightC;

final class LibLightsParser
extends AbstractElementParserChar {
    private COLLADAParser colladaParser = null;
    private LibLights libLights = null;
    private boolean isLight = false;
    private LightC currLight = null;
    private boolean isLightType = false;

    LibLightsParser(COLLADAParser cOLLADAParser, LibLights libLights) {
        super(cOLLADAParser.cfp);
        this.colladaParser = cOLLADAParser;
        this.libLights = libLights;
        this.charArray = new char[200];
    }

    void setup(LibLights libLights) {
        this.libLights = libLights;
        this.arrPos = 0;
        this.isCharacter = false;
    }

    @Override
    void doClose() {
        this.colladaParser = null;
        this.charArray = null;
    }

    @Override
    void startElement(String string) {
        if (this.isLight) {
            if (this.isLightType) {
                if (string.equals("color")) {
                    this.currLight.colorSID = this.cfp.xR.getAttributeValue(null, "sid");
                } else if (this.currLight.lightType == LightC.Type.POINT || this.currLight.lightType == LightC.Type.SPOT) {
                    if (string.equals("constant_attenuation")) {
                        this.currLight.constAttSID = this.cfp.xR.getAttributeValue(null, "sid");
                    } else if (string.equals("linear_attenuation")) {
                        this.currLight.linearAttSID = this.cfp.xR.getAttributeValue(null, "sid");
                    } else if (string.equals("quadratic_attenuation")) {
                        this.currLight.quadAttSID = this.cfp.xR.getAttributeValue(null, "sid");
                    } else if (string.equals("falloff_angle")) {
                        this.currLight.angleSID = this.cfp.xR.getAttributeValue(null, "sid");
                    } else if (string.equals("falloff_exponent")) {
                        this.currLight.exponentSID = this.cfp.xR.getAttributeValue(null, "sid");
                    } else if (string.equals("zfar")) {
                        this.currLight.zFarSID = this.cfp.xR.getAttributeValue(null, "sid");
                    }
                }
                this.isCharacter = true;
                this.arrPos = 0;
            } else if (string.equals("ambient")) {
                this.currLight.lightType = LightC.Type.AMBIENT;
                this.isLightType = true;
            } else if (string.equals("directional")) {
                this.currLight.lightType = LightC.Type.DIRECTIONAL;
                this.isLightType = true;
            } else if (string.equals("point")) {
                this.currLight.lightType = LightC.Type.POINT;
                this.isLightType = true;
            } else if (string.equals("spot")) {
                this.currLight.lightType = LightC.Type.SPOT;
                this.isLightType = true;
            } else if (string.equals("technique")) {
                System.out.println("LibLightsParser light : technique not supported, profil = " + this.cfp.xR.getAttributeValue(null, "profile"));
                this.cfp.setNullParser(this, string);
            } else if (string.equals("asset")) {
                Asset asset;
                this.currLight.asset = asset = new Asset();
                this.cfp.setAssetParser(this, asset);
            } else if (string.equals("extra")) {
                this.cfp.setNullParser(this, string);
            }
        } else if (string.equals("light")) {
            this.currLight = new LightC();
            this.currLight.id = this.cfp.xR.getAttributeValue(null, "id");
            this.currLight.name = this.cfp.xR.getAttributeValue(null, "name");
            this.libLights.addLight(this.currLight);
            this.isLight = true;
        } else if (string.equals("asset")) {
            Asset asset;
            this.libLights.asset = asset = new Asset();
            this.cfp.setAssetParser(this, asset);
        } else if (string.equals("extra")) {
            this.cfp.setNullParser(this, string);
        }
    }

    @Override
    void endElement(String string) {
        if (this.isLightType) {
            if (this.isCharacter) {
                String string2 = this.cUtils().trimString(this.charArray, this.arrPos);
                if (string.equals("color")) {
                    float[] fArray = new float[3];
                    this.cUtils().splitFloatInto(string2, fArray);
                    this.currLight.color = fArray;
                } else if (this.currLight.lightType == LightC.Type.POINT || this.currLight.lightType == LightC.Type.SPOT) {
                    float f = Float.parseFloat(string2);
                    if (string.equals("constant_attenuation")) {
                        this.currLight.constantAttenuation = f;
                    } else if (string.equals("linear_attenuation")) {
                        this.currLight.linearAttenuation = f;
                    } else if (string.equals("quadratic_attenuation")) {
                        this.currLight.quadraticAttenuation = f;
                    } else if (string.equals("falloff_angle")) {
                        this.currLight.falloffAngle = f;
                    } else if (string.equals("falloff_exponent")) {
                        this.currLight.falloffExponent = f;
                    } else if (string.equals("zfar")) {
                        this.currLight.zFar = f;
                    }
                }
                this.isCharacter = false;
            } else if (string.equals("ambient")) {
                this.isLightType = false;
            } else if (string.equals("directional")) {
                this.isLightType = false;
            } else if (string.equals("point")) {
                this.isLightType = false;
            } else if (string.equals("spot")) {
                this.isLightType = false;
            }
        } else if (string.equals("light")) {
            this.currLight = null;
            this.isLight = false;
        } else if (string.equals("library_lights")) {
            this.cfp.setParser(this.colladaParser);
            this.libLights = null;
        }
    }
}

