/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.AbstractElementParser;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.COLLADAParser;
import com.interactivemesh.jfx.importer.col.LibMaterials;
import com.interactivemesh.jfx.importer.col.Material;
import com.interactivemesh.jfx.importer.col.SetParam;
import com.interactivemesh.jfx.importer.col.TechniqueHint;

final class LibMaterialsParser
extends AbstractElementParser {
    private COLLADAParser colladaParser = null;
    private LibMaterials libMaterial = null;
    private Material currMaterial = null;
    private boolean isMaterial = false;
    private boolean isInstanceEffect = false;

    LibMaterialsParser(COLLADAParser cOLLADAParser, LibMaterials libMaterials) {
        super(cOLLADAParser.cfp);
        this.colladaParser = cOLLADAParser;
        this.libMaterial = libMaterials;
    }

    void setup(LibMaterials libMaterials) {
        this.libMaterial = libMaterials;
    }

    @Override
    void doClose() {
        this.colladaParser = null;
    }

    @Override
    void startElement(String string) {
        if (this.isMaterial) {
            if (this.isInstanceEffect) {
                if (string.equals("setparam")) {
                    SetParam setParam = new SetParam(this.cfp.xR.getAttributeValue(null, "ref"), this.cfp.xR.getAttributeValue(null, "program"));
                    this.currMaterial.instEffectSetParamList.add(setParam);
                    this.cfp.setNSParamParser(this, setParam);
                } else if (string.equals("technique_hint")) {
                    TechniqueHint techniqueHint = new TechniqueHint();
                    techniqueHint.platform = this.cfp.xR.getAttributeValue(null, "platform");
                    techniqueHint.ref = this.cfp.xR.getAttributeValue(null, "ref");
                    techniqueHint.profile = this.cfp.xR.getAttributeValue(null, "profile");
                    this.currMaterial.instEffectTechHintList.add(techniqueHint);
                } else if (string.equals("extra")) {
                    this.cfp.setNullParser(this, string);
                }
            } else if (string.equals("instance_effect")) {
                this.currMaterial.instEffectSID = this.cfp.xR.getAttributeValue(null, "sid");
                this.currMaterial.instEffectName = this.cfp.xR.getAttributeValue(null, "name");
                this.currMaterial.instEffectUrl = this.cfp.xR.getAttributeValue(null, "url");
                this.isInstanceEffect = true;
            } else if (string.equals("asset")) {
                Asset asset;
                this.currMaterial.asset = asset = new Asset();
                this.cfp.setAssetParser(this, asset);
            } else if (string.equals("extra")) {
                this.cfp.setNullParser(this, string);
            }
        } else if (string.equals("material")) {
            this.currMaterial = new Material();
            this.currMaterial.id = this.cfp.xR.getAttributeValue(null, "id");
            this.currMaterial.name = this.cfp.xR.getAttributeValue(null, "name");
            this.libMaterial.addMateria(this.currMaterial);
            this.isMaterial = true;
        } else if (string.equals("asset")) {
            Asset asset;
            this.libMaterial.asset = asset = new Asset();
            this.cfp.setAssetParser(this, asset);
        } else if (string.equals("extra")) {
            this.cfp.setNullParser(this, string);
        }
    }

    @Override
    void endElement(String string) {
        if (string.equals("instance_effect")) {
            this.isInstanceEffect = false;
        } else if (string.equals("material")) {
            this.isMaterial = false;
            this.currMaterial = null;
        } else if (string.equals("library_materials")) {
            this.cfp.setParser(this.colladaParser);
            this.libMaterial = null;
        }
    }
}

