/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.AbstractIdElement;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.ElementBase;
import com.interactivemesh.jfx.importer.col.ElementCache;
import javafx.scene.AmbientLight;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.PointLight;
import javafx.scene.paint.Color;

final class LightC
extends AbstractIdElement {
    Type lightType = null;
    String name = null;
    Asset asset = null;
    float[] color = null;
    String colorSID = null;
    float constantAttenuation = 1.0f;
    float linearAttenuation = 0.0f;
    float quadraticAttenuation = 0.0f;
    String constAttSID = null;
    String linearAttSID = null;
    String quadAttSID = null;
    float zFar = 0.0f;
    String zFarSID = null;
    float falloffAngle = 180.0f;
    float falloffExponent = 0.0f;
    String angleSID = null;
    String exponentSID = null;

    LightC() {
    }

    @Override
    void initialize(ElementBase elementBase, ElementCache elementCache) {
        super.initialize(elementBase, elementCache);
        if (this.id != null) {
            elementCache.putLight(this.id, this);
        }
        if (this.asset != null) {
            this.asset.initialize(elementBase, elementCache);
        }
    }

    private float clamp(float f) {
        if (f > 1.0f) {
            return 1.0f;
        }
        if (f < 0.0f) {
            return 0.0f;
        }
        return f;
    }

    LightBase getLight(String string) {
        Color color = Color.WHITE;
        if (this.color != null) {
            color = Color.color((double)this.clamp(this.color[0]), (double)this.clamp(this.color[1]), (double)this.clamp(this.color[2]));
        }
        AmbientLight ambientLight = null;
        switch (this.lightType) {
            case AMBIENT: {
                ambientLight = new AmbientLight(color);
                this.setLightId((LightBase)ambientLight, "AmbientLight", string);
                break;
            }
            case DIRECTIONAL: {
                ambientLight = new PointLight(color);
                this.setLightId((LightBase)ambientLight, "DirectionalLight", string);
                break;
            }
            case POINT: {
                ambientLight = new PointLight(color);
                this.setLightId((LightBase)ambientLight, "PointLight", string);
                break;
            }
            case SPOT: {
                ambientLight = new PointLight(color);
                this.setLightId((LightBase)ambientLight, "SpotLight", string);
            }
        }
        return ambientLight;
    }

    private void setLightId(LightBase lightBase, String string, String string2) {
        String string3 = null;
        string3 = string2 != null && string2.length() > 0 ? string2 : (this.name != null && this.name.length() > 0 ? this.name : (this.id != null && this.id.length() > 0 ? this.id : string));
        string3 = this.base.createUniqueName(string3);
        lightBase.setId(string3);
        this.base.putNamedNode(string3, (Node)lightBase);
    }

    static enum Type {
        AMBIENT,
        DIRECTIONAL,
        POINT,
        SPOT;

    }
}

