/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.AbstractElement;
import com.interactivemesh.jfx.importer.col.AbstractIdElement;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.CameraC;
import com.interactivemesh.jfx.importer.col.ColAsset;
import com.interactivemesh.jfx.importer.col.ElementBase;
import com.interactivemesh.jfx.importer.col.ElementCache;
import com.interactivemesh.jfx.importer.col.InstanceCamera;
import com.interactivemesh.jfx.importer.col.InstanceController;
import com.interactivemesh.jfx.importer.col.InstanceGeometry;
import com.interactivemesh.jfx.importer.col.InstanceLight;
import com.interactivemesh.jfx.importer.col.InstanceNode;
import com.interactivemesh.jfx.importer.col.LightC;
import com.interactivemesh.jfx.importer.col.TransformC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javafx.collections.ObservableList;
import javafx.scene.AmbientLight;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.ParallelCamera;
import javafx.scene.PerspectiveCamera;
import javafx.scene.PointLight;
import javafx.scene.paint.Color;
import javafx.scene.shape.MeshView;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

final class NodeC
extends AbstractIdElement {
    String name = null;
    String sid = null;
    String type = "NODE";
    ArrayList<String> layerList = null;
    Asset asset = null;
    private final ArrayList<TransformC> transformList = new ArrayList(5);
    private final ArrayList<InstanceCamera> viewpointChildElements = new ArrayList(2);
    private final ArrayList<AbstractElement> nodeChildElements = new ArrayList(10);
    private int numChildren = 0;

    NodeC(boolean bl, boolean bl2) {
    }

    @Override
    void initialize(ElementBase elementBase, ElementCache elementCache) {
        super.initialize(elementBase, elementCache);
        if (this.id != null) {
            elementCache.putNode(this.id, this);
        }
        this.numChildren = this.nodeChildElements.size();
        if (this.numChildren > 0) {
            for (AbstractElement abstractElement : this.nodeChildElements) {
                abstractElement.initialize(elementBase, elementCache);
            }
        }
        if (!this.viewpointChildElements.isEmpty()) {
            for (InstanceCamera instanceCamera : this.viewpointChildElements) {
                instanceCamera.initialize(elementBase, elementCache);
            }
        }
        if (this.asset != null) {
            this.asset.initialize(elementBase, elementCache);
        }
    }

    void addTransform(TransformC transformC) {
        this.transformList.add(transformC);
    }

    void addCamera(InstanceCamera instanceCamera, boolean bl) {
        if (bl) {
            this.viewpointChildElements.add(instanceCamera);
        } else {
            this.nodeChildElements.add(instanceCamera);
        }
    }

    void addLight(InstanceLight instanceLight) {
        this.nodeChildElements.add(instanceLight);
    }

    void addInstNode(InstanceNode instanceNode) {
        this.nodeChildElements.add(instanceNode);
    }

    void addController(InstanceController instanceController) {
        this.nodeChildElements.add(instanceController);
    }

    void addGeometry(InstanceGeometry instanceGeometry) {
        this.nodeChildElements.add(instanceGeometry);
    }

    void addNode(NodeC nodeC) {
        this.nodeChildElements.add(nodeC);
    }

    @Override
    void clear() {
        this.nodeChildElements.clear();
        this.transformList.clear();
        super.clear();
    }

    Node createSceneTopJ3DNode() {
        return this.getNode(null);
    }

    Node getNode(Group group) {
        Group object;
        block43: {
            Affine affine;
            Object object2;
            Object object3;
            HashMap<Camera, CameraC> hashMap;
            block42: {
                hashMap = null;
                if (!this.type.equalsIgnoreCase("NODE")) {
                    return null;
                }
                boolean bl = false;
                int n = this.transformList.size();
                object = null;
                if (this.numChildren == 1) {
                    LightBase lightBase;
                    LightC lightC;
                    object3 = this.nodeChildElements.get(0);
                    if (object3 instanceof InstanceGeometry) {
                        ArrayList<MeshView> object5 = ((InstanceGeometry)object3).getInstanceShape3Ds(this.name);
                        if (object5 != null && object5.size() > 0) {
                            if (object5.size() == 1) {
                                object = (Node)object5.get(0);
                            } else {
                                object = new Group();
                                object.getChildren().addAll(object5);
                                if (this.setUniqueId(this.name, (Node)object) == null && this.setUniqueId(((InstanceGeometry)object3).name, (Node)object) == null) {
                                    this.setUniqueId("Group", (Node)object);
                                }
                            }
                        }
                    } else if (object3 instanceof InstanceNode) {
                        Node node = ((InstanceNode)object3).getNodeOrClone(group);
                        if (node != null) {
                            if (n == 0) {
                                object = node;
                            } else {
                                object = new Group();
                                object.getChildren().add((Object)node);
                                if (this.setUniqueId(this.name, (Node)object) == null && this.setUniqueId(((InstanceNode)object3).name, (Node)object) == null) {
                                    this.setUniqueId("Group", (Node)object);
                                }
                            }
                        }
                    } else if (object3 instanceof InstanceController) {
                        ArrayList<MeshView> arrayList = ((InstanceController)object3).getInstanceShape3Ds();
                        if (arrayList != null) {
                            if (arrayList.size() == 1 && n == 0) {
                                object = (Node)arrayList.get(0);
                            } else {
                                object = new Group();
                                object.getChildren().addAll(arrayList);
                                if (this.setUniqueId(this.name, (Node)object) == null && this.setUniqueId(((InstanceController)object3).name, (Node)object) == null) {
                                    this.setUniqueId("Group", (Node)object);
                                }
                            }
                        }
                    } else if (object3 instanceof InstanceCamera) {
                        CameraC cameraC = this.cache.getCamera(((InstanceCamera)object3).url);
                        if (cameraC != null) {
                            Camera camera = cameraC.getCamera(this.name);
                            if (camera != null) {
                                object = camera;
                                bl = true;
                                this.base.addCamera(camera);
                            }
                            if (hashMap == null) {
                                hashMap = new HashMap<Camera, CameraC>(2);
                            }
                            hashMap.put(camera, cameraC);
                        }
                    } else if (object3 instanceof InstanceLight && (lightC = this.cache.getLight(((InstanceLight)object3).url)) != null && (lightBase = lightC.getLight(this.name)) != null) {
                        object = lightBase;
                        this.base.addLight(lightBase);
                    }
                }
                if (object == null && this.numChildren > 0) {
                    object = new Group();
                    if (this.setUniqueId(this.name, (Node)object) == null) {
                        this.setUniqueId("Group", (Node)object);
                    }
                    object3 = object.getChildren();
                    for (AbstractElement abstractElement : this.nodeChildElements) {
                        if (abstractElement instanceof InstanceGeometry) {
                            object2 = ((InstanceGeometry)abstractElement).getInstanceShape3Ds(null);
                            if (object2 == null || ((ArrayList)object2).size() <= 0) continue;
                            if (((ArrayList)object2).size() == 1) {
                                object3.add(((ArrayList)object2).get(0));
                                continue;
                            }
                            object3.addAll((Collection)object2);
                            continue;
                        }
                        if (abstractElement instanceof NodeC) {
                            object2 = ((NodeC)abstractElement).getNode(object);
                            if (object2 == null) continue;
                            object3.add(object2);
                            continue;
                        }
                        if (abstractElement instanceof InstanceNode) {
                            object2 = ((InstanceNode)abstractElement).getNodeOrClone(object);
                            if (object2 == null) continue;
                            object3.add(object2);
                            continue;
                        }
                        if (abstractElement instanceof InstanceController) {
                            object2 = ((InstanceController)abstractElement).getInstanceShape3Ds();
                            if (object2 == null || ((ArrayList)object2).size() <= 0) continue;
                            object3.addAll((Collection)object2);
                            continue;
                        }
                        if (abstractElement instanceof InstanceLight) {
                            object2 = this.cache.getLight(((InstanceLight)abstractElement).url);
                            if (object2 == null || (affine = ((LightC)object2).getLight(null)) == null) continue;
                            object3.add((Object)affine);
                            this.base.addLight((LightBase)affine);
                            continue;
                        }
                        if (!(abstractElement instanceof InstanceCamera) || (object2 = this.cache.getCamera(((InstanceCamera)abstractElement).url)) == null) continue;
                        affine = ((CameraC)object2).getCamera(null);
                        if (affine != null) {
                            object3.add((Object)affine);
                            this.base.addCamera((Camera)affine);
                        }
                        if (hashMap == null) {
                            hashMap = new HashMap(2);
                        }
                        hashMap.put((Camera)affine, (CameraC)object2);
                    }
                }
                if (object == null && this.numChildren == 0 && this.viewpointChildElements.isEmpty() && n > 0 && this.setUniqueId(this.name, (Node)(object = new Group())) == null) {
                    this.setUniqueId("Group", (Node)object);
                }
                if (object != null && n > 0) {
                    object3 = object.getTransforms();
                    for (TransformC transformC : this.transformList) {
                        object2 = transformC.getTransform(bl);
                        if (object2 == null) continue;
                        object3.add(object2);
                    }
                }
                if (!this.base.isIgnoreCameras || this.viewpointChildElements.isEmpty()) break block42;
                for (InstanceCamera instanceCamera : this.viewpointChildElements) {
                    CameraC cameraC = this.cache.getCamera(instanceCamera.url);
                    if (cameraC == null) continue;
                    object2 = null;
                    object2 = object == null && this.viewpointChildElements.size() == 1 ? cameraC.getCameraName(this.name) : cameraC.getCameraName(null);
                    affine = this.getVpTransform(group, (Node)object);
                    cameraC.createViewpointFromCamera(affine, (String)object2);
                }
                break block43;
            }
            if (hashMap == null) break block43;
            object3 = hashMap.keySet();
            for (Camera camera : object3) {
                object2 = (CameraC)hashMap.get(camera);
                affine = this.getVpTransform(group, (Node)object);
                ((CameraC)object2).createViewpointFromCamera(affine, camera.getId());
            }
        }
        return object;
    }

    private Affine getVpTransform(Group group, Node node) {
        Affine affine;
        block11: {
            ObservableList observableList;
            block10: {
                Object object;
                affine = new Affine();
                if (this.base.upAxis == ColAsset.UpAxis.Z_UP) {
                    affine.append((Transform)new Rotate(-90.0, Rotate.X_AXIS));
                } else if (this.base.upAxis == ColAsset.UpAxis.X_UP) {
                    affine.append((Transform)new Rotate(-90.0, Rotate.Z_AXIS));
                }
                if (group != null) {
                    object = new ArrayList();
                    while (group != null) {
                        ((ArrayList)object).add(group);
                        group = (Group)group.getParent();
                    }
                    for (int i = ((ArrayList)object).size() - 1; i >= 0; --i) {
                        observableList = ((Group)((ArrayList)object).get(i)).getTransforms();
                        if (observableList == null || observableList.size() <= 0) continue;
                        for (Transform transform : observableList) {
                            affine.append(transform);
                        }
                    }
                }
                if (node == null) break block10;
                object = node.getTransforms();
                if (object == null || object.size() <= 0) break block11;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    observableList = (Transform)iterator.next();
                    affine.append((Transform)observableList);
                }
                break block11;
            }
            if (!this.transformList.isEmpty()) {
                for (TransformC transformC : this.transformList) {
                    observableList = transformC.getTransform(true);
                    if (observableList == null) continue;
                    affine.append((Transform)observableList);
                }
            }
        }
        return affine;
    }

    Node cloneNode(Node node) {
        if (node == null) {
            return null;
        }
        Group group = null;
        if (node instanceof Group) {
            group = this.cloneGroup((Group)node);
        } else if (node instanceof MeshView) {
            group = this.cloneMeshView((MeshView)node);
        } else if (node instanceof LightBase) {
            group = this.cloneLight((LightBase)node);
        } else if (node instanceof Camera) {
            group = this.cloneCamera((Camera)node);
        } else {
            System.out.println("NodeC.cloneNode not supported node : " + node.toString());
        }
        return group;
    }

    private Group cloneGroup(Group group) {
        ObservableList observableList = group.getChildren();
        Group group2 = new Group();
        this.setUniqueId(group.getId(), (Node)group2);
        this.setTransformsToClone((ObservableList<Transform>)group.getTransforms(), (Node)group2);
        int n = observableList.size();
        if (n > 0) {
            ObservableList observableList2 = group2.getChildren();
            for (int i = 0; i < n; ++i) {
                Node node = (Node)observableList.get(i);
                Group group3 = null;
                if (node instanceof Group) {
                    group3 = this.cloneGroup((Group)node);
                } else if (node instanceof MeshView) {
                    group3 = this.cloneMeshView((MeshView)node);
                } else if (node instanceof LightBase) {
                    group3 = this.cloneLight((LightBase)node);
                } else if (node instanceof Camera) {
                    group3 = this.cloneCamera((Camera)node);
                } else {
                    System.out.println("NodeC.cloneGroup not supported node : " + node.toString());
                }
                if (group3 == null) continue;
                observableList2.add((Object)group3);
            }
        }
        return group2;
    }

    private MeshView cloneMeshView(MeshView meshView) {
        MeshView meshView2 = new MeshView();
        this.setUniqueId(meshView.getId(), (Node)meshView2);
        this.setTransformsToClone((ObservableList<Transform>)meshView.getTransforms(), (Node)meshView2);
        meshView2.setCullFace(meshView.getCullFace());
        meshView2.setDrawMode(meshView.getDrawMode());
        meshView2.setMaterial(meshView.getMaterial());
        meshView2.setMesh(meshView.getMesh());
        return meshView2;
    }

    private LightBase cloneLight(LightBase lightBase) {
        AmbientLight ambientLight = null;
        Color color = lightBase.getColor();
        if (lightBase instanceof AmbientLight) {
            ambientLight = new AmbientLight(color);
        } else if (lightBase instanceof PointLight) {
            ambientLight = new PointLight(color);
        } else {
            return null;
        }
        this.setUniqueId(lightBase.getId(), (Node)ambientLight);
        this.setTransformsToClone((ObservableList<Transform>)lightBase.getTransforms(), (Node)ambientLight);
        return ambientLight;
    }

    private Camera cloneCamera(Camera camera) {
        ParallelCamera parallelCamera = null;
        if (camera instanceof ParallelCamera) {
            parallelCamera = new ParallelCamera();
        } else if (camera instanceof PerspectiveCamera) {
            parallelCamera = new PerspectiveCamera(((PerspectiveCamera)camera).isFixedEyeAtCameraZero());
            ((PerspectiveCamera)parallelCamera).setFieldOfView(((PerspectiveCamera)camera).getFieldOfView());
            ((PerspectiveCamera)parallelCamera).setVerticalFieldOfView(((PerspectiveCamera)camera).isVerticalFieldOfView());
        }
        parallelCamera.setNearClip(camera.getNearClip());
        parallelCamera.setFarClip(camera.getFarClip());
        this.setUniqueId(camera.getId(), (Node)parallelCamera);
        this.setTransformsToClone((ObservableList<Transform>)camera.getTransforms(), (Node)parallelCamera);
        return parallelCamera;
    }

    private void setTransformsToClone(ObservableList<Transform> observableList, Node node) {
        if (observableList.size() > 0) {
            node.getTransforms().setAll(observableList);
        }
    }

    private String setUniqueId(String string, Node node) {
        String string2 = this.base.createUniqueName(string);
        if (string2 != null) {
            node.setId(string2);
            this.base.putNamedNode(string2, node);
        }
        return string2;
    }
}

