/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.AbstractElement;
import com.interactivemesh.jfx.importer.col.ElementBase;
import com.interactivemesh.jfx.importer.col.ElementCache;

final class Sampler
extends AbstractElement {
    private final SaSuType type;
    String surfaceSID = null;
    String instImageUrl = null;
    String instImageSID = null;
    String instImageName = null;
    Wrap wrapS = Wrap.WRAP;
    Wrap wrapT = Wrap.WRAP;
    Wrap wrapP = Wrap.WRAP;
    Filter minFilter = Filter.NONE;
    Filter magFilter = Filter.NONE;
    Filter mipFilter = Filter.NONE;
    float[] borderColor = null;
    int mipMinLevel = 0;
    int mipMaxLevel = 255;
    float mipBias = 0.0f;
    int maxAnisotropy = 1;

    Sampler(String string) {
        this.type = string.equals("sampler2D") ? SaSuType.D2 : (string.equals("sampler1D") ? SaSuType.D1 : (string.equals("sampler3D") ? SaSuType.D3 : (string.equals("samplerCUBE") ? SaSuType.CUBE : (string.equals("samplerDEPTH") ? SaSuType.DEPTH : (string.equals("samplerRECT") ? SaSuType.RECT : null)))));
    }

    @Override
    void initialize(ElementBase elementBase, ElementCache elementCache) {
        super.initialize(elementBase, elementCache);
    }

    SaSuType getType() {
        return this.type;
    }

    Wrap getWrap(String string) {
        Wrap wrap = null;
        if (string.equals("CLAMP")) {
            wrap = Wrap.CLAMP;
        } else if (string.equals("BORDER")) {
            wrap = Wrap.BORDER;
        } else if (string.equals("MIRROR")) {
            wrap = Wrap.MIRROR;
        } else if (string.equals("NONE")) {
            wrap = Wrap.NONE;
        } else if (string.equals("WRAP")) {
            wrap = Wrap.WRAP;
        } else if (string.equals("MIRROR_ONCE")) {
            wrap = Wrap.WRAP;
        }
        return wrap;
    }

    Filter getFilter(String string) {
        Filter filter = null;
        if (string.equals("NEAREST")) {
            filter = Filter.NEAREST;
        } else if (string.equals("LINEAR")) {
            filter = Filter.LINEAR;
        } else if (string.equals("ANISOTROPIC")) {
            filter = Filter.ANISOTROPIC;
        } else if (string.equals("NEAREST_MIPMAP_NEAREST")) {
            filter = Filter.NEAREST_MIPMAP_NEAREST;
        } else if (string.equals("LINEAR_MIPMAP_NEAREST")) {
            filter = Filter.LINEAR_MIPMAP_NEAREST;
        } else if (string.equals("NEAREST_MIPMAP_LINEAR")) {
            filter = Filter.NEAREST_MIPMAP_LINEAR;
        } else if (string.equals("LINEAR_MIPMAP_LINEAR")) {
            filter = Filter.LINEAR_MIPMAP_LINEAR;
        } else if (string.equals("NONE")) {
            filter = Filter.NONE;
        }
        return filter;
    }

    static enum Filter {
        NONE,
        NEAREST,
        LINEAR,
        NEAREST_MIPMAP_NEAREST,
        LINEAR_MIPMAP_NEAREST,
        NEAREST_MIPMAP_LINEAR,
        LINEAR_MIPMAP_LINEAR,
        ANISOTROPIC;

    }

    static enum Wrap {
        NONE,
        WRAP,
        MIRROR,
        CLAMP,
        BORDER,
        MIRROR_ONCE;

    }

    static enum SaSuType {
        D1,
        D2,
        D3,
        CUBE,
        DEPTH,
        RECT,
        UNTYPED;

    }
}

