/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.AbstractIdElement;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.ColAsset;
import com.interactivemesh.jfx.importer.col.ElementBase;
import com.interactivemesh.jfx.importer.col.ElementCache;
import com.interactivemesh.jfx.importer.col.NodeC;
import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.transform.Rotate;

final class VisualScene
extends AbstractIdElement {
    String name = null;
    Asset asset = null;
    private final ArrayList<NodeC> nodeList = new ArrayList();

    VisualScene() {
    }

    @Override
    void initialize(ElementBase elementBase, ElementCache elementCache) {
        super.initialize(elementBase, elementCache);
        if (this.id != null) {
            this.cache.putVisualScene(this.id, this);
        }
        for (NodeC nodeC : this.nodeList) {
            nodeC.initialize(elementBase, elementCache);
        }
        if (this.asset != null) {
            this.asset.initialize(elementBase, elementCache);
        }
    }

    @Override
    void clear() {
        this.nodeList.clear();
        super.clear();
    }

    void addNode(NodeC nodeC) {
        this.nodeList.add(nodeC);
    }

    ArrayList<Node> createScene(ColAsset.UpAxis upAxis) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (upAxis == ColAsset.UpAxis.Y_UP) {
            for (NodeC nodeC : this.nodeList) {
                Node node = nodeC.createSceneTopJ3DNode();
                if (node == null) continue;
                arrayList.add(node);
            }
        } else {
            Group group = new Group();
            String string = "AddedRootGroup";
            if (upAxis == ColAsset.UpAxis.X_UP) {
                group.getTransforms().add((Object)new Rotate(-90.0, Rotate.Z_AXIS));
                string = string + "_xUp";
            } else if (upAxis == ColAsset.UpAxis.Z_UP) {
                group.getTransforms().add((Object)new Rotate(-90.0, Rotate.X_AXIS));
                string = string + "_zUp";
            }
            String string2 = this.base.createUniqueName(string);
            if (string2 != null) {
                group.setId(string2);
                this.base.putNamedNode(string2, (Node)group);
            }
            ObservableList observableList = group.getChildren();
            for (NodeC nodeC : this.nodeList) {
                Node node = nodeC.createSceneTopJ3DNode();
                if (node == null) continue;
                observableList.add((Object)node);
            }
            if (!observableList.isEmpty()) {
                arrayList.add((Node)group);
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }
}

