/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.x3d;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.x3d.AbstractElementParser;
import com.interactivemesh.jfx.importer.x3d.AppearanceNode;
import com.interactivemesh.jfx.importer.x3d.ImageTextureNode;
import com.interactivemesh.jfx.importer.x3d.MaterialNode;
import com.interactivemesh.jfx.importer.x3d.XFileParser;
import javafx.scene.paint.Color;

final class AppearanceParser
extends AbstractElementParser {
    private final ImageTextureParser imgTexParser;
    private final MaterialParser materialParser = new MaterialParser(this);
    private AbstractElementParser parentParser = null;
    private AppearanceNode currAppear = null;

    AppearanceParser(XFileParser xFileParser) {
        super(xFileParser);
        this.imgTexParser = new ImageTextureParser(this);
    }

    void setup(AppearanceNode appearanceNode, AbstractElementParser abstractElementParser) {
        this.currAppear = appearanceNode;
        this.parentParser = abstractElementParser;
    }

    @Override
    void close() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void startElement(String string) {
        String string2 = this.xfp.xR.getAttributeValue(null, "DEF");
        String string3 = this.xfp.xR.getAttributeValue(null, "USE");
        if (string.equals("Material")) {
            if (string3 != null) {
                MaterialNode materialNode = this.currAppear.cache.getMaterialNode(string3);
                if (materialNode == null) throw new ImportException("AppearanceParser : shared " + string + " node not found for USE = " + string3);
                materialNode.setUSE(string3);
                this.currAppear.materialNode = materialNode;
                return;
            } else {
                MaterialNode materialNode = new MaterialNode(this.currAppear.base, this.currAppear.cache);
                materialNode.setDEF(string2);
                this.currAppear.materialNode = materialNode;
                this.materialParser.setup(materialNode);
                this.xfp.setParser(this.materialParser);
            }
            return;
        } else if (string.equals("ImageTexture")) {
            if (string3 != null) {
                ImageTextureNode imageTextureNode = this.currAppear.cache.getImageTexNode(string3);
                if (imageTextureNode == null) throw new ImportException("AppearanceParser : shared " + string + " node not found for USE = " + string3);
                imageTextureNode.setUSE(string3);
                this.currAppear.imgTexNode = imageTextureNode;
                return;
            } else {
                ImageTextureNode imageTextureNode = new ImageTextureNode(this.currAppear.base, this.currAppear.cache);
                imageTextureNode.setDEF(string2);
                this.currAppear.imgTexNode = imageTextureNode;
                this.imgTexParser.setup(imageTextureNode);
                this.xfp.setParser(this.imgTexParser);
            }
            return;
        } else if (string.startsWith("Metadata")) {
            this.currAppear.setMetaData(this.xfp.setMetaParser(this, string, string2, string3, this.currAppear.cache));
            return;
        } else {
            this.xfp.setNullParser(this, string);
        }
    }

    @Override
    void endElement(String string) {
        if (string.equals("Appearance")) {
            this.xfp.setParser(this.parentParser);
            this.parentParser = null;
            this.currAppear = null;
        }
    }

    private static final class MaterialParser
    extends AbstractElementParser {
        private final AbstractElementParser parentParser;
        private MaterialNode currMatNode = null;

        private MaterialParser(AppearanceParser appearanceParser) {
            super(appearanceParser.xfp);
            this.parentParser = appearanceParser;
        }

        private void setup(MaterialNode materialNode) {
            this.currMatNode = materialNode;
            String string = this.xfp.xR.getAttributeValue(null, "ambientIntensity");
            if (string != null) {
                this.currMatNode.ambientIntensity = Float.parseFloat(string);
            }
            if ((string = this.xfp.xR.getAttributeValue(null, "shininess")) != null) {
                this.currMatNode.shininess = Float.parseFloat(string);
            }
            if ((string = this.xfp.xR.getAttributeValue(null, "transparency")) != null) {
                this.currMatNode.transparency = Float.parseFloat(string);
            }
            float[] fArray = null;
            string = this.xfp.xR.getAttributeValue(null, "diffuseColor");
            if (string != null) {
                fArray = this.currMatNode.base.xUtils.getFloatArray(string);
                if (fArray != null && fArray.length == 3) {
                    this.currMatNode.diffuseColor = Color.color((double)fArray[0], (double)fArray[1], (double)fArray[2]);
                } else {
                    throw new ImportException("MaterialNodeParser : material has strange 'diffuseColor' = " + string);
                }
            }
            if ((string = this.xfp.xR.getAttributeValue(null, "emissiveColor")) != null) {
                fArray = this.currMatNode.base.xUtils.getFloatArray(string);
                if (fArray != null && fArray.length == 3) {
                    this.currMatNode.emissiveColor = Color.color((double)fArray[0], (double)fArray[1], (double)fArray[2]);
                } else {
                    throw new ImportException("MaterialNodeParser : material has strange 'emissiveColor' = " + string);
                }
            }
            if ((string = this.xfp.xR.getAttributeValue(null, "specularColor")) != null) {
                fArray = this.currMatNode.base.xUtils.getFloatArray(string);
                if (fArray != null && fArray.length == 3) {
                    this.currMatNode.specularColor = Color.color((double)fArray[0], (double)fArray[1], (double)fArray[2]);
                } else {
                    throw new ImportException("MaterialNodeParser : material has strange 'specularColor' = " + string);
                }
            }
        }

        @Override
        void close() {
        }

        @Override
        void startElement(String string) {
            if (string.startsWith("Metadata")) {
                String string2 = this.xfp.xR.getAttributeValue(null, "DEF");
                String string3 = this.xfp.xR.getAttributeValue(null, "USE");
                this.currMatNode.setMetaData(this.xfp.setMetaParser(this, string, string2, string3, this.currMatNode.cache));
            } else {
                this.xfp.setNullParser(this, string);
            }
        }

        @Override
        void endElement(String string) {
            if (string.equals("Material")) {
                this.xfp.setParser(this.parentParser);
                this.currMatNode = null;
            }
        }
    }

    private static final class ImageTextureParser
    extends AbstractElementParser {
        private final AbstractElementParser parentParser;
        private ImageTextureNode currImgTexNode = null;

        private ImageTextureParser(AppearanceParser appearanceParser) {
            super(appearanceParser.xfp);
            this.parentParser = appearanceParser;
        }

        private void setup(ImageTextureNode imageTextureNode) {
            this.currImgTexNode = imageTextureNode;
            this.currImgTexNode.urlsString = this.xfp.xR.getAttributeValue(null, "url");
            if (this.currImgTexNode.urlsString == null || this.currImgTexNode.urlsString.length() < 1) {
                throw new ImportException("ImageTextureParser url attribute is empty !!");
            }
        }

        @Override
        void close() {
        }

        @Override
        void startElement(String string) {
            String string2 = this.xfp.xR.getAttributeValue(null, "DEF");
            String string3 = this.xfp.xR.getAttributeValue(null, "USE");
            if (string.equals("TextureProperties")) {
                this.xfp.setNullParser(this, string);
            } else if (string.startsWith("Metadata")) {
                this.currImgTexNode.setMetaData(this.xfp.setMetaParser(this, string, string2, string3, this.currImgTexNode.cache));
            } else {
                this.xfp.setNullParser(this, string);
            }
        }

        @Override
        void endElement(String string) {
            if (string.equals("ImageTexture")) {
                this.xfp.setParser(this.parentParser);
                this.currImgTexNode = null;
            }
        }
    }
}

