/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.x3d;

import com.interactivemesh.jfx.image.ImageFactory;
import com.interactivemesh.jfx.importer.FilePath;
import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.Viewpoint;
import com.interactivemesh.jfx.importer.x3d.XImporterImpl;
import com.interactivemesh.jfx.importer.x3d.XIndexer;
import com.interactivemesh.jfx.importer.x3d.XMeshSmoother;
import com.interactivemesh.jfx.importer.x3d.XNormalizer;
import com.interactivemesh.jfx.importer.x3d.XUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.scene.AmbientLight;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.ParallelCamera;
import javafx.scene.PerspectiveCamera;
import javafx.scene.PointLight;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Box;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.Shape3D;
import javafx.scene.shape.Sphere;

final class ElementBase {
    XImporterImpl.BaseURL baseUrlMain;
    boolean isGenerateNormals = false;
    boolean isReverse = false;
    boolean isWritableImage = false;
    boolean isIgnoreCameras = false;
    boolean isIgnoreLights = false;
    double creaseAngle = (float)Math.toRadians(45.0);
    final XUtils xUtils;
    final XIndexer indexer;
    final XNormalizer normalizer;
    final XMeshSmoother smoother;
    final ImageFactory imgFactory;
    private final HashMap<String, Node> namedNodes = new HashMap();
    private final HashMap<String, PhongMaterial> namedMaterials = new HashMap();
    private final IdentityHashMap<Image, FilePath> imagePaths = new IdentityHashMap();
    private final IdentityHashMap<Group, FilePath> inlinePaths = new IdentityHashMap();
    private final ArrayList<Viewpoint> viewpointList = new ArrayList();
    private final ArrayList<Node> camLightList = new ArrayList();
    private long nameExt = 1L;
    private final HashSet<String> uniqueNames = new HashSet(100);
    private long matExt = 1L;
    private final String PhonMatName = "PhongMaterial_";

    ElementBase(XUtils xUtils) {
        this.xUtils = xUtils;
        this.imgFactory = new ImageFactory();
        this.indexer = new XIndexer();
        this.normalizer = new XNormalizer();
        this.smoother = new XMeshSmoother();
    }

    String createUniqueName(String string) {
        if (string == null || string.length() < 1) {
            return null;
        }
        boolean bl = this.uniqueNames.contains(string);
        if (bl) {
            String string2 = null;
            while (bl) {
                string2 = string + "_" + this.nameExt;
                ++this.nameExt;
                bl = this.uniqueNames.contains(string2);
            }
            this.uniqueNames.add(string2);
            return string2;
        }
        this.uniqueNames.add(string);
        return string;
    }

    void putNamedNode(String string, Node node) {
        if (string == null || node == null) {
            System.out.println("ElementBase putNamedNode name / node = " + string + " / " + node);
        } else {
            this.namedNodes.put(string, node);
        }
    }

    Map<String, Node> getNamedNodes() {
        int n = 0;
        n = this.namedNodes.size();
        if (n > 0) {
            HashMap<String, Node> hashMap = new HashMap<String, Node>(n, 1.0f);
            hashMap.putAll(this.namedNodes);
            return hashMap;
        }
        return null;
    }

    void putNamedMaterial(String string, PhongMaterial phongMaterial) {
        if (phongMaterial == null) {
            System.out.println("ElementCache putNamedMaterial name / material = " + string + " / " + phongMaterial);
        } else {
            if (string == null || string.length() < 1) {
                string = "PhongMaterial_" + this.matExt;
                ++this.matExt;
            }
            this.namedMaterials.put(string, phongMaterial);
        }
    }

    Map<String, PhongMaterial> getNamedMaterials() {
        int n = 0;
        n = this.namedMaterials.size();
        if (n > 0) {
            HashMap<String, PhongMaterial> hashMap = new HashMap<String, PhongMaterial>(n, 1.0f);
            hashMap.putAll(this.namedMaterials);
            return hashMap;
        }
        return null;
    }

    void putImagePath(Image image, FilePath filePath) {
        this.imagePaths.put(image, filePath);
    }

    IdentityHashMap<Image, FilePath> getImagePaths() {
        if (this.imagePaths.size() > 0) {
            IdentityHashMap<Image, FilePath> identityHashMap = new IdentityHashMap<Image, FilePath>();
            identityHashMap.putAll(this.imagePaths);
            return identityHashMap;
        }
        return null;
    }

    void putInlinePath(Group group, FilePath filePath) {
        this.inlinePaths.put(group, filePath);
    }

    IdentityHashMap<Group, FilePath> getInlinePaths() {
        if (this.inlinePaths.size() > 0) {
            IdentityHashMap<Group, FilePath> identityHashMap = new IdentityHashMap<Group, FilePath>();
            identityHashMap.putAll(this.inlinePaths);
            return identityHashMap;
        }
        return null;
    }

    void addViewpoint(Viewpoint viewpoint) {
        this.viewpointList.add(viewpoint);
    }

    Viewpoint[] getViewpoints() {
        Viewpoint[] viewpointArray = null;
        if (!this.viewpointList.isEmpty()) {
            viewpointArray = new Viewpoint[this.viewpointList.size()];
            int n = 0;
            for (Viewpoint viewpoint : this.viewpointList) {
                viewpointArray[n++] = viewpoint;
            }
        }
        return viewpointArray;
    }

    void addCamera(Camera camera) {
        this.camLightList.add((Node)camera);
    }

    void addLight(LightBase lightBase) {
        this.camLightList.add((Node)lightBase);
    }

    void clear() {
        this.isGenerateNormals = false;
        this.isReverse = false;
        this.isWritableImage = false;
        this.isIgnoreCameras = false;
        this.isIgnoreLights = false;
        this.creaseAngle = (float)Math.toRadians(44.0);
        this.namedNodes.clear();
        this.namedMaterials.clear();
        this.imagePaths.clear();
        this.viewpointList.clear();
        this.camLightList.clear();
        this.nameExt = 1L;
        this.uniqueNames.clear();
        this.matExt = 1L;
    }

    void close() {
        if (this.indexer != null) {
            this.indexer.close();
        }
        if (this.imgFactory != null) {
            this.imgFactory.close();
        }
    }

    Group cloneGroup(Group group) {
        String string;
        int n;
        ObservableList observableList = group.getChildren();
        Group group2 = new Group();
        ObservableList observableList2 = group.getTransforms();
        if (observableList2.size() > 0) {
            group2.getTransforms().setAll((Collection)observableList2);
        }
        if ((n = observableList.size()) > 0) {
            int n2;
            boolean bl = true;
            ObservableList observableList3 = group2.getChildren();
            for (n2 = 0; n2 < n; ++n2) {
                Node node = (Node)observableList.get(n2);
                Group group3 = null;
                if (node instanceof Group) {
                    group3 = this.cloneGroup((Group)node);
                } else if (node instanceof Shape3D) {
                    group3 = this.cloneShape3D((Shape3D)node);
                } else if (node instanceof LightBase) {
                    group3 = this.cloneLight((LightBase)node);
                } else if (node instanceof Camera) {
                    group3 = this.cloneCamera((Camera)node);
                } else {
                    System.out.println("ElementBase cloneGroup : not supported node : " + node.toString());
                }
                observableList3.add((Object)group3);
                bl = bl && node.isVisible();
            }
            if (!bl) {
                for (n2 = 0; n2 < n; ++n2) {
                    ((Node)observableList3.get(n2)).setVisible(((Node)observableList3.get(n2)).isVisible());
                }
            }
        }
        if ((string = this.createUniqueName(group.getId())) == null) {
            string = this.createUniqueName("TODO_sharedGrooup");
        }
        group2.setId(string);
        this.putNamedNode(string, (Node)group2);
        return group2;
    }

    Shape3D cloneShape3D(Shape3D shape3D) {
        MeshView meshView = null;
        if (shape3D instanceof MeshView) {
            meshView = new MeshView();
            meshView.setMesh(((MeshView)shape3D).getMesh());
        } else if (shape3D instanceof Box) {
            meshView = new Box(((Box)shape3D).getWidth(), ((Box)shape3D).getHeight(), ((Box)shape3D).getDepth());
        } else if (shape3D instanceof Cylinder) {
            meshView = new Cylinder(((Cylinder)shape3D).getRadius(), ((Cylinder)shape3D).getHeight(), ((Cylinder)shape3D).getDivisions());
        } else if (shape3D instanceof Sphere) {
            meshView = new Sphere(((Sphere)shape3D).getRadius(), ((Sphere)shape3D).getDivisions());
        } else {
            throw new ImportException("ElementBase cloneShape3D not supported type = " + shape3D);
        }
        meshView.setMaterial(shape3D.getMaterial());
        meshView.setCullFace(shape3D.getCullFace());
        meshView.setDrawMode(shape3D.getDrawMode());
        String string = this.createUniqueName(shape3D.getId());
        if (string == null) {
            string = this.createUniqueName("TODO_sharedShape3D");
        }
        meshView.setId(string);
        this.putNamedNode(string, (Node)meshView);
        return meshView;
    }

    LightBase cloneLight(LightBase lightBase) {
        String string;
        AmbientLight ambientLight = null;
        Color color = lightBase.getColor();
        String string2 = "PointLight";
        if (lightBase instanceof AmbientLight) {
            ambientLight = new AmbientLight(color);
            string2 = "AmbientLight";
        } else if (lightBase instanceof PointLight) {
            ambientLight = new PointLight(color);
        } else {
            throw new ImportException("ElementBase cloneLight not supported type = " + lightBase);
        }
        ambientLight.setLightOn(lightBase.isLightOn());
        ObservableList observableList = lightBase.getTransforms();
        if (observableList.size() > 0) {
            ambientLight.getTransforms().setAll((Collection)observableList);
        }
        if ((string = this.createUniqueName(lightBase.getId())) == null) {
            string = this.createUniqueName(string2);
        }
        ambientLight.setId(string);
        this.putNamedNode(string, (Node)ambientLight);
        this.addLight((LightBase)ambientLight);
        return ambientLight;
    }

    Camera cloneCamera(Camera camera) {
        String string;
        ParallelCamera parallelCamera = null;
        String string2 = "PerspectiveCamera";
        if (camera instanceof ParallelCamera) {
            parallelCamera = new ParallelCamera();
            string2 = "ParallelCamera";
        } else if (camera instanceof PerspectiveCamera) {
            parallelCamera = new PerspectiveCamera(((PerspectiveCamera)camera).isFixedEyeAtCameraZero());
            ((PerspectiveCamera)parallelCamera).setFieldOfView(((PerspectiveCamera)camera).getFieldOfView());
            ((PerspectiveCamera)parallelCamera).setVerticalFieldOfView(((PerspectiveCamera)camera).isVerticalFieldOfView());
        } else {
            throw new ImportException("ElementBase cloneCamera not supported type = " + camera);
        }
        parallelCamera.setNearClip(camera.getNearClip());
        parallelCamera.setFarClip(camera.getFarClip());
        ObservableList observableList = camera.getTransforms();
        if (observableList.size() > 0) {
            parallelCamera.getTransforms().setAll((Collection)observableList);
        }
        if ((string = this.createUniqueName(camera.getId())) == null) {
            string = this.createUniqueName(string2);
        }
        parallelCamera.setId(string);
        this.putNamedNode(string, (Node)parallelCamera);
        this.addCamera((Camera)parallelCamera);
        return parallelCamera;
    }
}

