/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.x3d;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.x3d.AbstractElementParser;
import com.interactivemesh.jfx.importer.x3d.LightNode;
import com.interactivemesh.jfx.importer.x3d.XFileParser;
import javafx.scene.paint.Color;
import javafx.scene.transform.Translate;

final class LightParser
extends AbstractElementParser {
    private AbstractElementParser parentParser = null;
    private LightNode currLightNode = null;
    private String tagName = null;

    LightParser(XFileParser xFileParser) {
        super(xFileParser);
    }

    void setup(LightNode lightNode, AbstractElementParser abstractElementParser, String string) {
        this.currLightNode = lightNode;
        this.parentParser = abstractElementParser;
        this.tagName = string;
        int n = -1;
        String string2 = this.xfp.xR.getAttributeValue(null, "color");
        if (string2 != null) {
            n = this.xfp.base.xUtils.splitFloats(string2);
            if (n == 3) {
                float[] fArray = this.xfp.base.xUtils.getFloatValues();
                this.currLightNode.color = Color.color((double)fArray[0], (double)fArray[1], (double)fArray[2]);
            } else {
                throw new ImportException("LightParser color : length != 3. Is >" + string2 + "<");
            }
        }
        if ((string2 = this.xfp.xR.getAttributeValue(null, "on")) != null) {
            this.currLightNode.on = Boolean.parseBoolean(string2);
        }
        if (string.startsWith("Directional")) {
            this.currLightNode.isDirectional = true;
        } else if (string.startsWith("Point")) {
            this.currLightNode.isPoint = true;
            string2 = this.xfp.xR.getAttributeValue(null, "location");
            if (string2 != null) {
                this.setLocation(string2);
            }
        } else if (string.startsWith("Spot")) {
            this.currLightNode.isSpot = true;
            string2 = this.xfp.xR.getAttributeValue(null, "location");
            if (string2 != null) {
                this.setLocation(string2);
            }
        }
    }

    private void setLocation(String string) {
        float[] fArray;
        int n = this.xfp.base.xUtils.splitFloats(string);
        if (n == 3) {
            fArray = this.xfp.base.xUtils.getFloatValues();
            if ((double)fArray[1] != 0.0) {
                fArray[1] = -fArray[1];
            }
            if ((double)fArray[2] != 0.0) {
                fArray[2] = -fArray[2];
            }
        } else {
            throw new ImportException("ViewpointParser location : length != 3. Is >" + string + "<");
        }
        this.currLightNode.location = new Translate((double)fArray[0], (double)fArray[1], (double)fArray[2]);
    }

    @Override
    void close() {
    }

    @Override
    void startElement(String string) {
        String string2 = this.xfp.xR.getAttributeValue(null, "DEF");
        String string3 = this.xfp.xR.getAttributeValue(null, "USE");
        if (string.startsWith("Metadata")) {
            this.currLightNode.setMetaData(this.xfp.setMetaParser(this, string, string2, string3, this.currLightNode.cache));
        } else {
            this.xfp.setNullParser(this, string);
        }
    }

    @Override
    void endElement(String string) {
        if (string.equals(this.tagName)) {
            this.xfp.setParser(this.parentParser);
            this.parentParser = null;
            this.currLightNode = null;
        }
    }
}

