/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.x3d;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.x3d.AbstractElementParser;
import com.interactivemesh.jfx.importer.x3d.AbstractMetaData;
import com.interactivemesh.jfx.importer.x3d.ElementBase;
import com.interactivemesh.jfx.importer.x3d.ElementCache;
import com.interactivemesh.jfx.importer.x3d.MetaDataSet;
import com.interactivemesh.jfx.importer.x3d.MetaDataValue;
import com.interactivemesh.jfx.importer.x3d.XFileParser;
import java.util.ArrayList;
import java.util.IdentityHashMap;

final class MetadataParser
extends AbstractElementParser {
    private AbstractElementParser parentParser = null;
    private final IdentityHashMap<MetaDataSet, MetaDataSet> setParentMap = new IdentityHashMap();
    private String returnTag = null;
    private boolean isSet = false;
    private AbstractMetaData currMetaData = null;

    MetadataParser(XFileParser xFileParser) {
        super(xFileParser);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    AbstractMetaData setupForTopMetadata(AbstractElementParser abstractElementParser, String string, String string2, String string3, ElementBase elementBase, ElementCache elementCache) {
        this.parentParser = abstractElementParser;
        this.returnTag = string;
        if (string3 != null) {
            this.currMetaData = elementCache.getMetaData(string3);
            if (this.currMetaData == null) throw new ImportException("MetadataParser : shared " + string + " not found for USE = " + string3);
            this.currMetaData.setUSE(string3);
            return this.currMetaData;
        } else {
            this.isSet = string.endsWith("Set");
            if (this.isSet) {
                this.currMetaData = new MetaDataSet(elementBase, elementCache);
                this.setParentMap.clear();
                this.setParentMap.put((MetaDataSet)this.currMetaData, null);
            } else {
                this.currMetaData = this.createValue(string, elementBase, elementCache);
            }
            this.currMetaData.setDEF(string2);
            this.currMetaData.name = this.xfp.xR.getAttributeValue(null, "name");
            this.currMetaData.reference = this.xfp.xR.getAttributeValue(null, "reference");
        }
        return this.currMetaData;
    }

    private void setupForChildMetadataSet(MetaDataSet metaDataSet) {
        this.currMetaData = metaDataSet;
        this.setParentMap.put(metaDataSet, (MetaDataSet)this.currMetaData);
    }

    @Override
    void close() {
    }

    private MetaDataValue createValue(String string, ElementBase elementBase, ElementCache elementCache) {
        String string2 = this.xfp.xR.getAttributeValue(null, "value");
        Object[] objectArray = null;
        if (string.endsWith("Boolean")) {
            ArrayList<String> arrayList = this.xfp.base.xUtils.splitString(string2, string2.length() / 5);
            if (arrayList != null) {
                boolean[] blArray = new boolean[arrayList.size()];
                int n = 0;
                for (String string3 : arrayList) {
                    if (string3.equalsIgnoreCase("TRUE")) {
                        blArray[n++] = true;
                        continue;
                    }
                    blArray[n++] = false;
                }
                objectArray = blArray;
            }
        } else if (string.endsWith("Double")) {
            double[] dArray = this.xfp.base.xUtils.getDoubleArray(string2);
            if (dArray != null) {
                objectArray = dArray;
            }
        } else if (string.endsWith("Float")) {
            float[] fArray = this.xfp.base.xUtils.getFloatArray(string2);
            if (fArray != null) {
                objectArray = fArray;
            }
        } else if (string.endsWith("Integer")) {
            int[] nArray = this.xfp.base.xUtils.getIntArray(string2);
            if (nArray != null) {
                objectArray = nArray;
            }
        } else if (string.endsWith("String")) {
            ArrayList<String> arrayList = this.xfp.base.xUtils.getMFStrings(string2, true);
            if (arrayList != null) {
                String[] stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                objectArray = stringArray;
            }
        } else {
            System.out.println("XFileParser.metadataStartElement not valid nameElement = " + string);
        }
        return new MetaDataValue(elementBase, elementCache, objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void startElement(String string) {
        String string2 = this.xfp.xR.getAttributeValue(null, "DEF");
        String string3 = this.xfp.xR.getAttributeValue(null, "USE");
        String string4 = this.xfp.xR.getAttributeValue(null, "containerField");
        if (string4 == "value") {
            boolean bl = false;
            AbstractMetaData abstractMetaData = null;
            if (string3 != null) {
                abstractMetaData = this.currMetaData.cache.getMetaData(string3);
                if (abstractMetaData == null) throw new ImportException("MetadataParser : shared " + string + " not found for USE = " + string3);
                abstractMetaData.setUSE(string3);
            } else {
                if (string.endsWith("Set")) {
                    abstractMetaData = new MetaDataSet(this.currMetaData.base, this.currMetaData.cache);
                    bl = true;
                } else {
                    abstractMetaData = this.createValue(string, this.currMetaData.base, this.currMetaData.cache);
                }
                abstractMetaData.setDEF(string2);
                abstractMetaData.name = this.xfp.xR.getAttributeValue(null, "name");
                abstractMetaData.reference = this.xfp.xR.getAttributeValue(null, "reference");
            }
            ((MetaDataSet)this.currMetaData).add(abstractMetaData);
            if (bl) {
                this.setupForChildMetadataSet((MetaDataSet)abstractMetaData);
            }
        } else {
            this.xfp.setNullParser(this, string);
        }
        if (this.isSet && !string.equals(this.returnTag)) return;
    }

    @Override
    void endElement(String string) {
        if (string.equals(this.returnTag)) {
            MetaDataSet metaDataSet;
            if (this.isSet && (metaDataSet = this.setParentMap.get((MetaDataSet)this.currMetaData)) != null) {
                this.currMetaData = metaDataSet;
                return;
            }
            this.xfp.setParser(this.parentParser);
            this.currMetaData = null;
            this.parentParser = null;
            this.returnTag = null;
        }
    }
}

