/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.x3d;

import com.interactivemesh.jfx.importer.x3d.AbstractSceneElement;
import com.interactivemesh.jfx.importer.x3d.ElementBase;
import com.interactivemesh.jfx.importer.x3d.ElementCache;
import javafx.scene.shape.Box;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.Shape3D;
import javafx.scene.shape.Sphere;
import javafx.scene.shape.TriangleMesh;

final class PrimitiveNode
extends AbstractSceneElement {
    final Primitive prim;
    boolean solid = true;
    boolean bottom = true;
    boolean side = true;
    boolean top = true;
    float radius = 1.0f;
    float width = 2.0f;
    float height = 2.0f;
    float depth = 2.0f;
    private Shape3D sharedPrimitive = null;

    PrimitiveNode(Primitive primitive, ElementBase elementBase, ElementCache elementCache) {
        super(elementBase, elementCache);
        this.prim = primitive;
    }

    @Override
    void setDEF(String string) {
        if (string != null) {
            this.def = string;
            this.cache.putPrimitiveNode(string, this);
        }
    }

    @Override
    void initialize() {
    }

    @Override
    void clear() {
        super.clear();
    }

    Shape3D getShape3D(String string) {
        String string2;
        if (this.use != null && this.sharedPrimitive != null) {
            return this.base.cloneShape3D(this.sharedPrimitive);
        }
        MeshView meshView = null;
        String string3 = this.prim.name();
        switch (this.prim) {
            case BOX: {
                meshView = new Box((double)this.width, (double)this.height, (double)this.depth);
                if (!this.base.isReverse) break;
                meshView.setCullFace(CullFace.FRONT);
                break;
            }
            case CONE: {
                meshView = new MeshView();
                string3 = "MeshView";
                if (!this.bottom && !this.side) break;
                meshView.setMesh((Mesh)this.createConeMesh());
                break;
            }
            case CYLINDER: {
                if (this.bottom && this.side && this.top) {
                    meshView = new Cylinder((double)this.radius, (double)this.height);
                    if (!this.base.isReverse) break;
                    meshView.setCullFace(CullFace.FRONT);
                    break;
                }
                meshView = new MeshView();
                string3 = "MeshView";
                if (!this.bottom && !this.side && !this.top) break;
                meshView.setMesh((Mesh)this.createCylinderMesh());
                break;
            }
            case SPHERE: {
                meshView = new Sphere((double)this.radius);
                if (!this.base.isReverse) break;
                meshView.setCullFace(CullFace.FRONT);
            }
        }
        if (!this.solid) {
            meshView.setCullFace(CullFace.NONE);
        }
        if ((string2 = this.base.createUniqueName(this.def)) == null) {
            string2 = this.base.createUniqueName(string3);
        }
        meshView.setId(string2);
        if (this.use != null) {
            this.sharedPrimitive = meshView;
        }
        return meshView;
    }

    private void reverseFaceIndices(int[] nArray) {
        int n = -1;
        int n2 = 4;
        int n3 = nArray.length;
        for (int i = 0; i < n3; i += 6) {
            n = nArray[i + n2];
            nArray[i + n2] = nArray[i + 2];
            nArray[i + 2] = n;
            n = nArray[i + n2 + 1];
            nArray[i + n2] = nArray[i + 2 + 1];
            nArray[i + 2 + 1] = n;
        }
    }

    private TriangleMesh createConeMesh() {
        int n;
        float f = this.height / 2.0f;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        int n7 = -1;
        int n8 = 0;
        n2 += 64;
        if (this.side) {
            ++n2;
            n3 += 129;
            n8 += 64;
        }
        if (this.bottom) {
            ++n2;
            n3 += 65;
            n8 += 64;
        }
        float[] fArray = new float[n2 * 3];
        float[] fArray2 = new float[n3 * 2];
        int[] nArray = new int[n8 * 3];
        int[] nArray2 = new int[n8 * 3 * 2];
        int[] nArray3 = new int[n8];
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        for (n = 0; n < 64; ++n) {
            double d = (double)n * 0.09817477042468103;
            fArray[n9++] = (float)(Math.sin(d) * (double)this.radius);
            fArray[n9++] = f;
            fArray[n9++] = (float)(Math.cos(d) * (double)this.radius);
        }
        if (this.side) {
            n4 = n9 / 3;
            fArray[n9++] = 0.0f;
            fArray[n9++] = -f;
            fArray[n9++] = 0.0f;
        }
        if (this.bottom) {
            n5 = n9 / 3;
            fArray[n9++] = 0.0f;
            fArray[n9++] = f;
            fArray[n9++] = 0.0f;
        }
        if (this.side) {
            int n14 = 64;
            for (n = 0; n < n14; ++n) {
                fArray2[n10++] = 0.9921875f - (float)n * 0.015625f;
                fArray2[n10++] = 0.0f;
            }
            for (n = 0; n < 64; ++n) {
                fArray2[n10++] = 1.0f - (float)n * 0.015625f;
                fArray2[n10++] = 1.0f;
            }
            fArray2[n10++] = 0.0f;
            fArray2[n10++] = 1.0f;
        }
        if (this.bottom) {
            n6 = n10 / 2;
            for (n = 0; n < 64; ++n) {
                double d = (double)n * 0.09817477042468103;
                fArray2[n10++] = 0.5f + (float)(Math.sin(d) * 0.5);
                fArray2[n10++] = 0.5f + (float)(Math.cos(d) * 0.5);
            }
            n7 = n10 / 2;
            fArray2[n10++] = 0.5f;
            fArray2[n10] = 0.5f;
        }
        n9 = 0;
        n10 = 0;
        if (this.side) {
            int n15 = 63;
            for (n = 0; n < n15; ++n) {
                nArray2[n11] = n9++;
                nArray[n12++] = n10 + 64;
                nArray2[n11 += 2] = n4;
                nArray[n12++] = n10++;
                nArray2[n11 += 2] = n9;
                nArray[n12++] = n10 + 64;
                n11 += 2;
                nArray3[n13++] = 1;
            }
            nArray2[n11] = n9;
            nArray[n12++] = n10 + 64;
            nArray2[n11 += 2] = n4;
            nArray[n12++] = n10++;
            nArray2[n11 += 2] = 0;
            nArray[n12++] = n10 + 64;
            n11 += 2;
            nArray3[n13++] = 1;
        }
        if (this.bottom) {
            n9 = 0;
            n10 = n6;
            int n16 = 63;
            for (n = 0; n < n16; ++n) {
                nArray2[n11] = n9++;
                nArray[n12++] = n10++;
                nArray2[n11 += 2] = n9;
                nArray[n12++] = n10;
                nArray2[n11 += 2] = n5;
                nArray[n12++] = n7;
                n11 += 2;
                nArray3[n13++] = 2;
            }
            nArray2[n11] = n9;
            nArray[n12++] = n10;
            nArray2[n11 += 2] = 0;
            nArray[n12++] = n6;
            nArray2[n11 += 2] = n5;
            nArray[n12++] = n7;
            n11 += 2;
            nArray3[n13++] = 2;
        }
        fArray2 = this.base.indexer.createRFTuplesAndInds(fArray2, fArray2.length, nArray);
        n11 = 1;
        n12 = 0;
        if (this.side) {
            for (n = 0; n < 64; ++n) {
                nArray2[n11] = nArray[n12++];
                nArray2[n11 += 2] = nArray[n12++];
                nArray2[n11 += 2] = nArray[n12++];
                n11 += 2;
            }
        }
        if (this.bottom) {
            for (n = 0; n < 64; ++n) {
                nArray2[n11] = nArray[n12++];
                nArray2[n11 += 2] = nArray[n12++];
                nArray2[n11 += 2] = nArray[n12++];
                n11 += 2;
            }
        }
        if (this.base.isReverse) {
            this.reverseFaceIndices(nArray2);
        }
        TriangleMesh triangleMesh = new TriangleMesh();
        triangleMesh.getPoints().setAll(fArray);
        triangleMesh.getTexCoords().setAll(fArray2);
        triangleMesh.getFaces().setAll(nArray2);
        triangleMesh.getFaceSmoothingGroups().setAll(nArray3);
        return triangleMesh;
    }

    private TriangleMesh createCylinderMesh() {
        double d;
        int n;
        float f = this.height / 2.0f;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        int n9 = 0;
        if (this.side) {
            n2 += 128;
            n3 += 130;
            n9 += 128;
            if (this.top) {
                ++n2;
                n3 += 64;
                n9 += 64;
            }
            if (this.bottom) {
                ++n2;
                n3 += 64;
                n9 += 64;
            }
            if (this.top || this.bottom) {
                ++n3;
            }
        } else {
            if (this.top) {
                n2 += 65;
                n3 += 64;
                n9 += 64;
            }
            if (this.bottom) {
                n2 += 65;
                n3 += 64;
                n9 += 64;
            }
            if (this.top || this.bottom) {
                ++n3;
            }
        }
        float[] fArray = new float[n2 * 3];
        float[] fArray2 = new float[n3 * 2];
        int[] nArray = new int[n9 * 3];
        int[] nArray2 = new int[n9 * 3 * 2];
        int[] nArray3 = new int[n9];
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        if (this.top || this.side) {
            for (n = 0; n < 64; ++n) {
                d = (double)n * 0.09817477042468103;
                fArray[n10++] = (float)(Math.sin(d) * (double)this.radius);
                fArray[n10++] = -f;
                fArray[n10++] = (float)(Math.cos(d) * (double)this.radius);
            }
        }
        if (this.bottom || this.side) {
            for (n = 0; n < 64; ++n) {
                d = (double)n * 0.09817477042468103;
                fArray[n10++] = (float)(Math.sin(d) * (double)this.radius);
                fArray[n10++] = f;
                fArray[n10++] = (float)(Math.cos(d) * (double)this.radius);
            }
        }
        if (this.top) {
            n4 = n10 / 3;
            fArray[n10++] = 0.0f;
            fArray[n10++] = -f;
            fArray[n10++] = 0.0f;
        }
        if (this.bottom) {
            n5 = n10 / 3;
            fArray[n10++] = 0.0f;
            fArray[n10++] = f;
            fArray[n10++] = 0.0f;
        }
        if (this.side) {
            for (n = 0; n < 64; ++n) {
                fArray2[n11++] = 1.0f - (float)n * 0.015625f;
                fArray2[n11++] = 0.0f;
            }
            for (n = 0; n < 64; ++n) {
                fArray2[n11++] = 1.0f - (float)n * 0.015625f;
                fArray2[n11++] = 1.0f;
            }
            fArray2[n11++] = 0.0f;
            fArray2[n11++] = 0.0f;
            fArray2[n11++] = 0.0f;
            fArray2[n11++] = 1.0f;
        }
        if (this.top) {
            n6 = n11 / 2;
            for (n = 0; n < 64; ++n) {
                d = (double)n * 0.09817477042468103;
                fArray2[n11++] = 0.5f + (float)(Math.sin(d) * 0.5);
                fArray2[n11++] = 0.5f - (float)(Math.cos(d) * 0.5);
            }
        }
        if (this.bottom) {
            n7 = n11 / 2;
            for (n = 0; n < 64; ++n) {
                d = (double)n * 0.09817477042468103;
                fArray2[n11++] = 0.5f + (float)(Math.sin(d) * 0.5);
                fArray2[n11++] = 0.5f + (float)(Math.cos(d) * 0.5);
            }
        }
        if (this.top || this.bottom) {
            n8 = n11 / 2;
            fArray2[n11++] = 0.5f;
            fArray2[n11] = 0.5f;
        }
        n10 = 0;
        n11 = 0;
        if (this.side) {
            int n15 = 63;
            for (n = 0; n < n15; ++n) {
                nArray2[n12] = n10 + 64;
                nArray[n13++] = nArray2[n12];
                nArray2[n12 += 2] = n10;
                nArray[n13++] = nArray2[n12];
                nArray2[n12 += 2] = n10 + 1;
                nArray[n13++] = nArray2[n12];
                nArray2[n12 += 2] = n10 + 64;
                nArray[n13++] = nArray2[n12];
                nArray2[n12 += 2] = ++n10;
                nArray[n13++] = nArray2[n12];
                nArray2[n12 += 2] = n10 + 64;
                nArray[n13++] = nArray2[n12];
                n12 += 2;
                nArray3[n14++] = 1;
                nArray3[n14++] = 1;
            }
            nArray2[n12] = n10 + 64;
            nArray[n13++] = nArray2[n12];
            nArray2[n12 += 2] = n10;
            nArray[n13++] = nArray2[n12];
            nArray2[n12 += 2] = 0;
            nArray[n13++] = n10 + 64 + 1;
            nArray2[n12 += 2] = n10 + 64;
            nArray[n13++] = nArray2[n12];
            nArray2[n12 += 2] = 0;
            nArray[n13++] = n10 + 64 + 1;
            nArray2[n12 += 2] = 64;
            nArray[n13++] = n10 + 64 + 2;
            n12 += 2;
            nArray3[n14++] = 1;
            nArray3[n14++] = 1;
        }
        if (this.top) {
            n10 = 0;
            n11 = n6;
            int n16 = 63;
            for (n = 0; n < n16; ++n) {
                nArray2[n12] = n10++;
                nArray[n13++] = n11++;
                nArray2[n12 += 2] = n4;
                nArray[n13++] = n8;
                nArray2[n12 += 2] = n10;
                nArray[n13++] = n11;
                n12 += 2;
                nArray3[n14++] = 2;
            }
            nArray2[n12] = n10;
            nArray[n13++] = n11;
            nArray2[n12 += 2] = n4;
            nArray[n13++] = n8;
            nArray2[n12 += 2] = 0;
            nArray[n13++] = n6;
            n12 += 2;
            nArray3[n14++] = 2;
        }
        if (this.bottom) {
            n10 = this.top || this.side ? 64 : 0;
            n11 = n7;
            int n17 = 63;
            for (n = 0; n < n17; ++n) {
                nArray2[n12] = n10++;
                nArray[n13++] = n11++;
                nArray2[n12 += 2] = n10;
                nArray[n13++] = n11;
                nArray2[n12 += 2] = n5;
                nArray[n13++] = n8;
                n12 += 2;
                nArray3[n14++] = 2;
            }
            nArray2[n12] = n10;
            nArray[n13++] = n11;
            nArray2[n12 += 2] = this.top || this.side ? 64 : 0;
            nArray[n13++] = n7;
            nArray2[n12 += 2] = n5;
            nArray[n13++] = n8;
            n12 += 2;
            nArray3[n14++] = 2;
        }
        fArray2 = this.base.indexer.createRFTuplesAndInds(fArray2, fArray2.length, nArray);
        n12 = 1;
        n13 = 0;
        if (this.side) {
            for (n = 0; n < 64; ++n) {
                nArray2[n12] = nArray[n13++];
                nArray2[n12 += 2] = nArray[n13++];
                nArray2[n12 += 2] = nArray[n13++];
                nArray2[n12 += 2] = nArray[n13++];
                nArray2[n12 += 2] = nArray[n13++];
                nArray2[n12 += 2] = nArray[n13++];
                n12 += 2;
            }
        }
        if (this.top) {
            for (n = 0; n < 64; ++n) {
                nArray2[n12] = nArray[n13++];
                nArray2[n12 += 2] = nArray[n13++];
                nArray2[n12 += 2] = nArray[n13++];
                n12 += 2;
            }
        }
        if (this.bottom) {
            for (n = 0; n < 64; ++n) {
                nArray2[n12] = nArray[n13++];
                nArray2[n12 += 2] = nArray[n13++];
                nArray2[n12 += 2] = nArray[n13++];
                n12 += 2;
            }
        }
        if (this.base.isReverse) {
            this.reverseFaceIndices(nArray2);
        }
        TriangleMesh triangleMesh = new TriangleMesh();
        triangleMesh.getPoints().setAll(fArray);
        triangleMesh.getTexCoords().setAll(fArray2);
        triangleMesh.getFaces().setAll(nArray2);
        triangleMesh.getFaceSmoothingGroups().setAll(nArray3);
        return triangleMesh;
    }

    static enum Primitive {
        BOX,
        CONE,
        CYLINDER,
        SPHERE;

    }
}

