/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.x3d;

import com.interactivemesh.jfx.importer.Viewpoint;
import com.interactivemesh.jfx.importer.x3d.AbstractNodeElement;
import com.interactivemesh.jfx.importer.x3d.ElementBase;
import com.interactivemesh.jfx.importer.x3d.ElementCache;
import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.geometry.Point3D;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.ParallelCamera;
import javafx.scene.PerspectiveCamera;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;

final class ViewpointNode
extends AbstractNodeElement {
    Point3D centerOfRotation = null;
    String description = null;
    float fieldOfView = (float)Math.toDegrees(0.7854f);
    Rotate orientation = null;
    Translate position = null;
    boolean isPerspective = false;
    private Camera sharedCamera = null;

    ViewpointNode(ElementBase elementBase, ElementCache elementCache) {
        super(elementBase, elementCache);
    }

    @Override
    void setDEF(String string) {
        if (string != null) {
            this.def = string;
            this.cache.putViewpointNode(string, this);
        }
    }

    @Override
    void initialize() {
    }

    @Override
    void clear() {
        this.sharedCamera = null;
        super.clear();
    }

    @Override
    Node getNode(Group group) {
        Object object;
        Affine affine;
        ParallelCamera parallelCamera = null;
        if (!this.base.isIgnoreCameras) {
            if (this.sharedCamera != null && this.use != null) {
                parallelCamera = this.base.cloneCamera(this.sharedCamera);
            } else {
                if (this.isPerspective) {
                    parallelCamera = new PerspectiveCamera(true);
                    ((PerspectiveCamera)parallelCamera).setFieldOfView((double)this.fieldOfView);
                    ((PerspectiveCamera)parallelCamera).setVerticalFieldOfView(true);
                } else {
                    parallelCamera = new ParallelCamera();
                }
                affine = parallelCamera.getTransforms();
                if (this.position != null) {
                    affine.add((Object)this.position);
                }
                if (this.orientation != null) {
                    affine.add((Object)this.orientation);
                }
                if ((object = this.description) == null && (object = this.base.createUniqueName(this.def)) == null) {
                    object = this.isPerspective ? this.base.createUniqueName("PerspectiveCamera") : this.base.createUniqueName("ParallelCamera");
                }
                parallelCamera.setId((String)object);
                this.base.putNamedNode((String)object, (Node)parallelCamera);
                this.base.addCamera((Camera)parallelCamera);
                if (this.use != null) {
                    this.sharedCamera = parallelCamera;
                }
            }
        }
        affine = this.getVpTransform(group, this.orientation, this.position);
        object = new Viewpoint();
        ((Viewpoint)object).setFieldOfView(this.fieldOfView);
        String string = this.description;
        if (string == null && (parallelCamera == null || (string = parallelCamera.getId()) == null) && (string = this.base.createUniqueName(this.def)) == null) {
            string = this.isPerspective ? this.base.createUniqueName("PerspectiveCamera") : this.base.createUniqueName("ParallelCamera");
        }
        ((Viewpoint)object).setName(string);
        ((Viewpoint)object).setPerspectiveProjection(this.isPerspective);
        ((Viewpoint)object).setTransform(affine);
        if (this.centerOfRotation != null) {
            ((Viewpoint)object).setCenterOfRotation(this.centerOfRotation);
        }
        ((Viewpoint)object).setVerticalFieldOfView(true);
        this.base.addViewpoint((Viewpoint)object);
        return parallelCamera;
    }

    private Affine getVpTransform(Group group, Rotate rotate, Translate translate) {
        Affine affine = new Affine();
        if (group != null) {
            ArrayList<Group> arrayList = new ArrayList<Group>();
            while (group != null) {
                arrayList.add(group);
                group = (Group)group.getParent();
            }
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                ObservableList observableList = ((Group)arrayList.get(i)).getTransforms();
                if (observableList == null || observableList.size() <= 0) continue;
                for (Transform transform : observableList) {
                    affine.append(transform);
                }
            }
        }
        if (translate != null) {
            affine.append((Transform)translate);
        }
        if (rotate != null) {
            affine.append((Transform)rotate);
        }
        return affine;
    }
}

