/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.x3d;

import com.interactivemesh.jfx.importer.FilePath;
import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.ModelImporter;
import com.interactivemesh.jfx.importer.Viewpoint;
import com.interactivemesh.jfx.importer.x3d.ElementBase;
import com.interactivemesh.jfx.importer.x3d.ElementCache;
import com.interactivemesh.jfx.importer.x3d.SceneX;
import com.interactivemesh.jfx.importer.x3d.X3D;
import com.interactivemesh.jfx.importer.x3d.X3dHead;
import com.interactivemesh.jfx.importer.x3d.X3dImportOption;
import com.interactivemesh.jfx.importer.x3d.XFileParser;
import com.interactivemesh.jfx.importer.x3d.XUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Map;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.paint.PhongMaterial;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;

final class XImporterImpl {
    private URL baseUrlU = null;
    private String basePathU = null;
    private boolean isUserBase = false;
    private BaseURL baseUrlUser = null;
    private double creaseAngle = Math.toRadians(45.0);
    private final EnumSet<X3dImportOption> x3dOpts = EnumSet.of(X3dImportOption.NONE);
    private boolean isClosed = false;
    private final XMLInputFactory xmlif;
    private final XFileParser x3dFileParser;
    private final ArrayList<XFileParser> inlineParsers = new ArrayList(4);
    private final ElementBase base;
    private final XUtils xUtils;
    private Node[] sceneNodeReturnList = null;
    private X3dHead head = null;
    private int[] layerOrder = null;
    private final ModelImporter importer;

    XImporterImpl(ModelImporter modelImporter) {
        this.importer = modelImporter;
        this.xUtils = new XUtils();
        this.base = new ElementBase(this.xUtils);
        try {
            this.xmlif = XMLInputFactory.newInstance();
            this.xmlif.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
            this.xmlif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            this.xmlif.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            this.xmlif.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
            throw new ImportException("TODO", factoryConfigurationError);
        }
        this.x3dFileParser = new XFileParser(this, this.xmlif, this.base);
    }

    XFileParser getInlineParser() {
        if (this.inlineParsers.isEmpty()) {
            return new XFileParser(this, this.xmlif, this.base);
        }
        return this.inlineParsers.remove(this.inlineParsers.size() - 1);
    }

    void cacheInlineParser(XFileParser xFileParser) {
        this.inlineParsers.add(xFileParser);
    }

    double getCreaseAngle() {
        return Math.toDegrees(this.creaseAngle);
    }

    void setCreaseAngle(double d) {
        double d2 = Math.toRadians(d);
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > Math.PI) {
            d2 = 3.1415927410125732;
        }
        this.creaseAngle = d2;
    }

    String getResourcePath() {
        return this.basePathU;
    }

    void setResourcePath(String string) {
        this.baseUrlU = null;
        this.basePathU = string;
        boolean bl = this.isUserBase = string != null && string.length() > 0;
        if (this.isUserBase) {
            URL uRL;
            string.trim();
            string = string.replace('\\', '/');
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            if ((uRL = this.xUtils.getUrlForAbsolutPath(string)) == null) {
                throw new ImportException("X3dModelImporter setResourcePath : Can't create absolute URL from = " + string);
            }
            this.baseUrlUser = new BaseURL();
            this.baseUrlUser.protocol = uRL.getProtocol();
            this.baseUrlUser.host = uRL.getHost();
            this.baseUrlUser.port = uRL.getPort();
            this.baseUrlUser.path = uRL.getPath();
        } else {
            this.baseUrlUser = null;
        }
    }

    URL getResourceUrl() {
        return this.baseUrlU;
    }

    void setResourceUrl(URL uRL) {
        this.basePathU = null;
        this.baseUrlU = uRL;
        boolean bl = this.isUserBase = uRL != null;
        if (this.isUserBase) {
            this.baseUrlUser = new BaseURL();
            this.baseUrlUser.protocol = uRL.getProtocol();
            this.baseUrlUser.host = uRL.getHost();
            this.baseUrlUser.port = uRL.getPort();
            this.baseUrlUser.path = uRL.getPath();
            if (!this.baseUrlUser.path.endsWith("/")) {
                this.baseUrlUser.path = this.baseUrlUser.path + "/";
            }
        } else {
            this.baseUrlUser = null;
        }
    }

    EnumSet<X3dImportOption> getOptions() {
        return this.x3dOpts.clone();
    }

    void setOptions(X3dImportOption ... x3dImportOptionArray) {
        if (x3dImportOptionArray == null || x3dImportOptionArray.length < 1) {
            throw new IllegalArgumentException("options is null || options' length < 1");
        }
        if (x3dImportOptionArray.length > 1) {
            for (X3dImportOption x3dImportOption : x3dImportOptionArray) {
                if (x3dImportOption != X3dImportOption.NONE) continue;
                throw new IllegalArgumentException("options include X3dImportOption.NONE");
            }
        }
        this.x3dOpts.clear();
        for (X3dImportOption x3dImportOption : x3dImportOptionArray) {
            this.x3dOpts.add(x3dImportOption);
        }
    }

    void setOptions(EnumSet<X3dImportOption> enumSet) {
        if (enumSet == null || enumSet.isEmpty()) {
            throw new IllegalArgumentException("options is null || options is empty");
        }
        if (enumSet.size() > 1) {
            for (X3dImportOption x3dImportOption : enumSet) {
                if (x3dImportOption != X3dImportOption.NONE) continue;
                throw new IllegalArgumentException("options include X3dImportOption.NONE");
            }
        }
        this.x3dOpts.clear();
        this.x3dOpts.addAll(enumSet);
    }

    void read(File file) throws ImportException {
        if (this.checkIsClosed()) {
            return;
        }
        if (file == null) {
            throw new ImportException("X3dModelImporter read(File file) : file is null !");
        }
        if (!file.exists()) {
            throw new ImportException("X3dModelImporter read(File file) : file doesn't exist !");
        }
        if (file.isDirectory()) {
            throw new ImportException("X3dModelImporter read(File file) : file is directory !");
        }
        if (!file.canRead()) {
            throw new ImportException("X3dModelImporter read(File file) : file can't be read !");
        }
        try {
            URL uRL = file.toURI().toURL();
            BaseURL baseURL = new BaseURL();
            baseURL.protocol = uRL.getProtocol();
            baseURL.host = uRL.getHost();
            baseURL.port = uRL.getPort();
            baseURL.path = uRL.getPath();
            int n = baseURL.path.lastIndexOf(47);
            if (n >= 0) {
                baseURL.path = baseURL.path.substring(0, n + 1);
            } else if (n < 0) {
                baseURL.path = Character.toString('/');
            }
            this.importFile(new FileInputStream(file), baseURL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ImportException("X3dModelImporter read(File file)", malformedURLException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ImportException("X3dModelImporter read(File file)", fileNotFoundException);
        }
    }

    void read(String string) throws ImportException {
        if (this.checkIsClosed()) {
            return;
        }
        if (string == null || string.length() < 1) {
            throw new ImportException("X3dModelImporter read(String fileName) : fileName is null !");
        }
        URL uRL = null;
        try {
            Object object;
            string = string.replace('\\', '/');
            uRL = this.xUtils.getUrlForAbsolutPath(string);
            if (uRL == null && ((String)(object = System.getProperty("user.dir"))).length() > 0) {
                if (((String)(object = ((String)object).replace('\\', '/'))).charAt(0) != '/') {
                    object = '/' + (String)object;
                }
                if (((String)object).charAt(((String)object).length() - 1) != '/') {
                    object = (String)object + '/';
                }
                uRL = new URL("file", null, this.xUtils.normalizePath((String)object, string));
            }
            if (uRL == null) {
                throw new ImportException("X3dModelImporter read(String fileName) : Can' create URL f0r = \n" + string);
            }
            object = new BaseURL();
            ((BaseURL)object).protocol = uRL.getProtocol();
            ((BaseURL)object).host = uRL.getHost();
            ((BaseURL)object).port = uRL.getPort();
            ((BaseURL)object).path = uRL.getPath();
            int n = ((BaseURL)object).path.lastIndexOf(47);
            if (n >= 0) {
                ((BaseURL)object).path = ((BaseURL)object).path.substring(0, n + 1);
            } else if (n < 0) {
                ((BaseURL)object).path = Character.toString('/');
            }
            URLConnection uRLConnection = uRL.openConnection();
            this.importFile(uRLConnection.getInputStream(), (BaseURL)object);
        }
        catch (SecurityException securityException) {
            throw new ImportException("X3dModelImporter read(String fileName)", securityException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ImportException("X3dModelImporter read(String fileName)", malformedURLException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ImportException("X3dModelImporter read(String fileName)", fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ImportException("X3dModelImporter read(String fileName)", unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new ImportException("X3dModelImporter read(String fileName)", iOException);
        }
    }

    void read(URL uRL) throws ImportException {
        if (this.checkIsClosed()) {
            return;
        }
        if (uRL == null) {
            throw new ImportException("X3dModelImporter read(URL url) : url is null !");
        }
        BaseURL baseURL = new BaseURL();
        baseURL.protocol = uRL.getProtocol();
        baseURL.host = uRL.getHost();
        baseURL.port = uRL.getPort();
        baseURL.path = uRL.getPath();
        int n = baseURL.path.lastIndexOf(47);
        baseURL.path = n >= 0 ? baseURL.path.substring(0, n + 1) : Character.toString('/');
        try {
            URLConnection uRLConnection = uRL.openConnection();
            this.importFile(uRLConnection.getInputStream(), baseURL);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ImportException("X3dModelImporter read(URL url)", fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ImportException("X3dModelImporter read(URL url)", unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new ImportException("X3dModelImporter read(URL url)", iOException);
        }
    }

    Node[] getImportedNodes() {
        Node[] nodeArray = null;
        int n = 0;
        if (this.sceneNodeReturnList != null && (n = this.sceneNodeReturnList.length) > 0) {
            nodeArray = new Node[n];
            for (int i = 0; i < n; ++i) {
                nodeArray[i] = this.sceneNodeReturnList[i];
            }
        }
        return nodeArray;
    }

    Map<String, Node> getNamedNodes() {
        return this.base.getNamedNodes();
    }

    Map<String, PhongMaterial> getNamedMaterials() {
        return this.base.getNamedMaterials();
    }

    IdentityHashMap<Image, FilePath> getImagePaths() {
        return this.base.getImagePaths();
    }

    IdentityHashMap<Group, FilePath> getInlinedX3DFilePaths() {
        return this.base.getInlinePaths();
    }

    Viewpoint[] getViewpoints() {
        return this.base.getViewpoints();
    }

    X3dHead getHead() {
        return this.head;
    }

    int[] getLayerOrder() {
        return this.layerOrder;
    }

    void clear() {
        this.base.clear();
        this.x3dFileParser.clear();
        if (!this.inlineParsers.isEmpty()) {
            for (XFileParser xFileParser : this.inlineParsers) {
                xFileParser.clear();
            }
        }
        this.sceneNodeReturnList = null;
        this.head = null;
        this.layerOrder = null;
    }

    void close() {
        this.isClosed = true;
        this.clear();
        this.base.close();
        this.x3dFileParser.close();
        if (!this.inlineParsers.isEmpty()) {
            for (XFileParser xFileParser : this.inlineParsers) {
                xFileParser.close();
            }
            this.inlineParsers.clear();
        }
    }

    private void clearForNextImport() {
        this.clear();
    }

    private boolean checkIsClosed() {
        if (this.isClosed) {
            throw new ImportException("X3dModelImporter is closed! Can't be used anymore!");
        }
        return this.isClosed;
    }

    private void importFile(InputStream inputStream, BaseURL baseURL) {
        this.clearForNextImport();
        if (this.x3dOpts != null && !this.x3dOpts.isEmpty()) {
            this.base.isGenerateNormals = this.x3dOpts.contains((Object)X3dImportOption.GENERATE_NORMALS);
            this.base.isReverse = this.x3dOpts.contains((Object)X3dImportOption.REVERSE_GEOMETRY);
            this.base.isWritableImage = this.x3dOpts.contains((Object)X3dImportOption.MAP_WRITABLEIMAGE);
            this.base.isIgnoreCameras = this.x3dOpts.contains((Object)X3dImportOption.IGNORE_CAMERAS);
            this.base.isIgnoreLights = this.x3dOpts.contains((Object)X3dImportOption.IGNORE_LIGHTS);
        }
        this.base.creaseAngle = this.creaseAngle;
        this.base.baseUrlMain = this.isUserBase ? this.baseUrlUser : baseURL;
        ElementCache elementCache = new ElementCache(this.base.baseUrlMain);
        X3D x3D = this.x3dFileParser.parse(inputStream, elementCache);
        x3D.initialize();
        SceneX sceneX = x3D.getScene();
        if (sceneX != null) {
            this.sceneNodeReturnList = sceneX.getTopNodes();
            this.layerOrder = sceneX.layerOrder;
        }
        this.head = x3D.getHead();
        x3D.clear();
        this.importer.onFileImported();
    }

    static final class BaseURL {
        String protocol = null;
        String host = null;
        int port = -1;
        String path = null;

        BaseURL() {
        }

        public String toString() {
            return "protocol = " + this.protocol + ", host = " + this.host + ", port = " + this.port + ", path = " + this.path;
        }
    }
}

