/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.image;

import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStreamImpl;

final class ImageIOInputStreamArray
extends ImageInputStreamImpl {
    private byte[] buffer = null;
    private int limit = -1;
    private boolean doPrint = false;

    ImageIOInputStreamArray() {
    }

    void setup(byte[] byArray, int n, ByteOrder byteOrder) {
        this.buffer = byArray;
        this.limit = n;
        this.setByteOrder(byteOrder);
        if (this.doPrint) {
            System.out.println("ImageIOInputStreamArray setup length = " + byArray.length + " / limit = " + n);
        }
        this.bitOffset = 0;
        this.flushedPos = 0L;
        this.streamPos = 0L;
    }

    void clear() {
        this.buffer = null;
    }

    @Override
    public void close() throws IOException {
        this.clear();
        super.close();
    }

    @Override
    public long length() {
        return this.limit;
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public boolean isCachedMemory() {
        return true;
    }

    @Override
    public boolean isCachedFile() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStreamArray read() !");
        }
        this.bitOffset = 0;
        if (this.streamPos < (long)this.limit) {
            return this.buffer[(int)this.streamPos++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStreamArray read(byte[] b, int off, int len) len = " + n2);
        }
        if (byArray == null) {
            throw new NullPointerException("b == null");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("((off < 0) || (len < 0) || (off + len > b.length)) b.length/off/len=)" + byArray.length + "/" + n + "/" + n2);
        }
        if (n2 == 0) {
            return 0;
        }
        this.bitOffset = 0;
        if (this.streamPos >= (long)this.limit) {
            return -1;
        }
        int n3 = (int)this.streamPos;
        if (n2 > this.limit - n3) {
            n2 = this.limit - n3;
        }
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            byArray[i] = this.buffer[n3++];
        }
        this.streamPos = n3;
        return n2;
    }
}

