package com.interactivemesh.j3d.testspace.jcanvas3d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * DistortStringReflectionPanel.java
 *
 * Version: 2.0
 * Date: 2009/03/09
 * 
 * Author:
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'DistortStringReflectionPanel.java'.
 *
 */
final class DistortStringReflectionPanel {

    private Font titleFont = null; 
    private Font textFont = null; 
    
    private Color bgColor = new Color(0.0f, 0.4f, 0.8f);
    private Color fgColor = new Color(1.0f, 1.0f, 1.0f);
    
    private int borderBLR = 50;
    private int borderT = 80;
        
    private int space = 10;
    
    private JLabel fpsValueLabel = null;

    private DistortStringReflection universe = null;
    
    
    DistortStringReflectionPanel() {
        
    }
    
    // JApplet
    void destroy() {
        universe.closeUniverse();
    }
    
    void addTo(Container container, final JLayeredPane jLayeredPane) {
        
        System.out.println("DistortStringReflection 2.0 is running.");
       
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int screenHeight = screenDim.height;
        
        // screenHeight >= 1200
        int textFontSize = 18;
        int titleFontSize = 30;
        borderBLR = 50;
        borderT = 80;
        space = 10;

        // screenHeight  < 1024
        if (screenHeight < 1024) {
            textFontSize = 14;
            titleFontSize = 24;
            borderBLR = 30;
            borderT = 50;
            space = 5;
        }
        // 1024 <= screenHeight < 1200
        else if (screenHeight < 1200) {
            textFontSize = 16;
            titleFontSize = 26;
            borderBLR = 40;
            borderT = 60;
            space = 8;
        }

        titleFont = new Font("Dialog", Font.PLAIN, titleFontSize); 
        textFont = new Font("Dialog", Font.PLAIN, textFontSize); 
        
        universe = new DistortStringReflection(this);
        
        // Initial values
        universe.setFraction(0.6f);
        universe.setTopOpacity(0.1f);
        universe.setBottomOpacity(0.9f);
        universe.setTopColorRGB(Color.BLACK);
        universe.setBottomColorRGB(Color.BLACK);
       
        // Wrapper of JCanvas3D
        JPanel jCanvas3D = universe.getJCanvas3D();        
        
        //
        // Title
        //
        JLabel titleLabel = new JLabel();
        titleLabel.setFont(titleFont);
        titleLabel.setForeground(fgColor);
        titleLabel.setText("JCanvas3DOB Reflection");
        titleLabel.setMinimumSize(new Dimension(100, borderT));
        titleLabel.setPreferredSize(new Dimension(100, borderT));
        titleLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, borderT));
        
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, BoxLayout.X_AXIS));
        titlePanel.setBackground(bgColor);
        titlePanel.setBorder(BorderFactory.createEmptyBorder(0, 2*space, 0, 0));
        
        titlePanel.add(titleLabel);
        titlePanel.add(Box.createHorizontalGlue()); 
        
        //
        // 3D Scene
        //
        JPanel scenePanel = new JPanel();
        scenePanel.setLayout(new BoxLayout(scenePanel, BoxLayout.X_AXIS));
        scenePanel.setBackground(bgColor);
        scenePanel.setBorder(BorderFactory.createLineBorder(Color.WHITE, 3));
        scenePanel.add(jCanvas3D, BorderLayout.CENTER);
        
        //
        // Actions
        //
        final JPanel actionPanel = new JPanel();
        actionPanel.setLayout(new BoxLayout(actionPanel, BoxLayout.X_AXIS));
        actionPanel.setOpaque(false);
        actionPanel.setBorder(BorderFactory.createEmptyBorder());
        
        // VantagePoints
        
        JPanel buttonPanel = new YPanel();
        
        ButtonLabel frontButtom = new ButtonLabel("Front") {
            @Override
            void action() {
                universe.setVantagePoint(this.getText());
            }
        };       
        ButtonLabel sideButton = new ButtonLabel("Side") {
            @Override
            void action() {
                universe.setVantagePoint(this.getText());
            }
        };
       
        buttonPanel.add(frontButtom);
        buttonPanel.add(sideButton);
        
        // Distort
        
        JPanel radioPanel = new YPanel();

        final JRadioButton distortRadio = new RadioButton("Distort");
        distortRadio.setSelected(true);
        
        final JRadioButton pauseRadio = new RadioButton("Pause");
        
        ActionListener distortListener = new ActionListener() { 
            public void actionPerformed(ActionEvent event) {
                universe.startStopDistort(distortRadio.isSelected());
            }
        };
        distortRadio.addActionListener(distortListener);
        pauseRadio.addActionListener(distortListener);
        
        ButtonGroup distortGroup = new ButtonGroup();
        distortGroup.add(distortRadio);
        distortGroup.add(pauseRadio);
        
        radioPanel.add(distortRadio);
        radioPanel.add(pauseRadio);
        
        // Frames per second
        
        JPanel fpsPanel = new YPanel();
        
        JLabel fpsTitleLabel = new Label("F P S");
        
        fpsValueLabel = new Label("123");
        
        fpsPanel.add(fpsTitleLabel);
        fpsPanel.add(Box.createVerticalGlue());
        fpsPanel.add(fpsValueLabel);
        
        // Fraction
       
        Dimension sliderSize = new Dimension(150, distortRadio.getPreferredSize().height);
        
        JPanel fractionPanel = new YPanel();

        JLabel fractionLabel = new Label("Fraction");
        
        final JSlider fractionSlider = new Slider(0, 100, 60, sliderSize);        
        fractionSlider.addChangeListener( new ChangeListener() {
            public void stateChanged(ChangeEvent sliderEvent) {
                if (!fractionSlider.getValueIsAdjusting()) {
                    int value = fractionSlider.getValue();
                    
                    universe.setFraction(value/100.0f);
                }
            }
        });
        
        fractionPanel.add(fractionLabel);
        fractionPanel.add(Box.createVerticalGlue());
        fractionPanel.add(fractionSlider);
       
        // Top Opacity
        
        JPanel topOpacityPanel = new YPanel();

        JLabel topOpacityLabel = new Label("Top Opacity");

        final JSlider topOpacitySlider = new Slider(0, 100, 10, sliderSize);       
        topOpacitySlider.addChangeListener( new ChangeListener() {
            public void stateChanged(ChangeEvent sliderEvent) {
                int value = topOpacitySlider.getValue();
               
                universe.setTopOpacity(value/100.0f);
            }
        });
        
        topOpacityPanel.add(topOpacityLabel);
        topOpacityPanel.add(Box.createVerticalGlue());
        topOpacityPanel.add(topOpacitySlider);

        // Bottom Opacity
        
        JPanel botOpacityPanel = new YPanel();

        JLabel botOpacityLabel = new Label("Bottom Opacity");

        final JSlider botOpacitySlider = new Slider(0, 100, 90, sliderSize);
        botOpacitySlider.addChangeListener( new ChangeListener() {
            public void stateChanged(ChangeEvent sliderEvent) {
                int value = botOpacitySlider.getValue();
               
                universe.setBottomOpacity(value/100.0f);
            }
        });
        
        botOpacityPanel.add(botOpacityLabel);
        botOpacityPanel.add(Box.createVerticalGlue());
        botOpacityPanel.add(botOpacitySlider);
        
        
        actionPanel.add(buttonPanel);
        actionPanel.add(Box.createHorizontalStrut(2*space));
        actionPanel.add(radioPanel);
        actionPanel.add(Box.createHorizontalStrut(2*space));
        actionPanel.add(fpsPanel);
        actionPanel.add(Box.createHorizontalStrut(2*space));
        actionPanel.add(fractionPanel);
        actionPanel.add(Box.createHorizontalStrut(space));
        actionPanel.add(topOpacityPanel);
        actionPanel.add(Box.createHorizontalStrut(space));
        actionPanel.add(botOpacityPanel);
        actionPanel.add(Box.createHorizontalGlue());
        
        Dimension actionSize = actionPanel.getPreferredSize();
        final int actionWidth = actionSize.width;
        final int actionHeight = actionSize.height;
                
        
        // Initial size
        int frameWidth = (int)(screenDim.width * 0.8f);
        int frameHeight = (int)(frameWidth * 0.6f);

        final JPanel framePanel = new JPanel();
        framePanel.setLayout(new BoxLayout(framePanel, BoxLayout.Y_AXIS));
        framePanel.setBackground(bgColor);
        framePanel.setBorder(BorderFactory.createEmptyBorder(0, borderBLR, borderBLR, borderBLR));
        framePanel.setPreferredSize(new Dimension(frameWidth, frameHeight));
        
        framePanel.add(titlePanel);
        framePanel.add(scenePanel);
        
        // ActionPanel in PALETTE_LAYER
        
        framePanel.addComponentListener(new ComponentAdapter() { 
            public void componentResized(ComponentEvent event) {
                Dimension size = jLayeredPane.getSize();
                actionPanel.setBounds(borderBLR+2*space, size.height-actionHeight-space-borderBLR, 
                                      actionWidth, actionHeight);     
                framePanel.revalidate(); 
                framePanel.repaint();
            }
        });
        
        jLayeredPane.add(actionPanel, JLayeredPane.PALETTE_LAYER);
       
        container.add(framePanel);
        
    }
    
    void updateFPS(int value) {
        fpsValueLabel.setText(String.valueOf(value));
    }
    
    final private class RadioButton extends JRadioButton {
        private RadioButton(String text) {
            super(text);
            setOpaque(false);
            setFont(textFont);
            setForeground(fgColor);
            setBorder(BorderFactory.createEmptyBorder());
        }
    }
    
    final private class YPanel extends JPanel {
        private YPanel() {
            setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
            setOpaque(false);
            setAlignmentY(JPanel.CENTER_ALIGNMENT);
        }
    }
    
    private class Label extends JLabel {
        private Label(String text) {
            super(text);
            setFont(textFont);
            setForeground(fgColor);
            setAlignmentX(JPanel.CENTER_ALIGNMENT);
        }
    }
    
    final private class Slider extends JSlider {       
        private Slider(int min, int max, int value, Dimension preferredSize) {
            super(min, max, value);
            setOpaque(false);
            setAlignmentX(JPanel.CENTER_ALIGNMENT);
            setBorder(BorderFactory.createEmptyBorder());
            setPreferredSize(preferredSize);
        }
    }
    
    private class ButtonLabel extends Label {
        
        private Color enterColor = Color.ORANGE;
        private Color pressColor = Color.RED;            
        private boolean isPressed = false;
       
        private ButtonLabel(String text) {
            super(text);

            addMouseListener(new MouseAdapter() { 
                
                public void mouseEntered(MouseEvent event) {
                    if (!isPressed)
                        setForeground(enterColor);
                }
                public void mouseExited(MouseEvent event) {
                    if (!isPressed)
                        setForeground(fgColor);
                }
                public void mousePressed(MouseEvent event) {
                    isPressed = true;
                    setForeground(pressColor);
                }
                public void mouseReleased(MouseEvent event) {
                    isPressed = false;
                    if (contains(event.getX(), event.getY())) {
                        setForeground(enterColor);                                  
                        action();
                    }
                    else
                        setForeground(fgColor);
                }
            });
        }
        
        void action() {
        }
    }
}
