package com.interactivemesh.j3d.community.gui;

/*
 * LICENSE
 * 
 * JCanvas3DOB.java 
 * 
 * extends 'com.interactivemesh.j3d.community.gui.JCanvas3DOBAbstract'.
 * 
 * Redistribution and use are permitted according to the following license notice
 * of JCanvas3DOBAbstract.
 * 
 * Version: 1.0
 * Date: 2009/03/09
 * 
 * Author:
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 * 
*/

/*
 * LICENSE
 * 
 * JCanvas3DOBAbstract.java 
 * 
 * is a derived work of the Java 3D utility class "com.sun.j3d.exp.swing.JCanvas3D.java".
 * 
 * Redistribution and use are permitted according to the following license notice
 * of JCanvas3D.
 * 
 * Version: 1.0
 * Date: 2009/03/09
 * 
 * Author:
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 * 
*/

/*
 * $RCSfile: com.sun.j3d.exp.swing.JCanvas3D.java,v $
 *
 * Copyright (c) 2007 Sun Microsystems, Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistribution of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistribution in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 *
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL
 * NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF
 * USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
 * DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR
 * ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * You acknowledge that this software is not designed, licensed or
 * intended for use in the design, construction, operation or
 * maintenance of any nuclear facility.
 *
 * $Revision: 1.10 $
 * $Date: 2007/04/11 02:08:56 $
 * $State: Exp $
 * 
 *  @author: Frederic 'pepe' Barachant
 *
 */

import java.awt.Graphics;
import java.awt.GraphicsDevice;

import javax.media.j3d.GraphicsConfigTemplate3D;

/**
 * JCanvas3DOB is a standard implementation of JCanvas3DOBAbstract. 
 * <p>
 * Serialization: JCanvas3DOB does not support serialization. 
 */
public class JCanvas3DOB extends JCanvas3DOBAbstract {

    /**
     * Constructs and initializes a new JCanvas3DOB object that Java 3D
     * can render into. The screen device is obtained from
     * <code>GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice()</code>,
     * which might not be the one you should use if you are in a multiscreen environment.
     * The JCanvas3DOB is constructed using the following default parameters:<br>
     * double buffer enable : false<br>
     * stereo enable : false<br>
     */
    public JCanvas3DOB() {
        this(null, null);
    }

    /**
     * Constructs and initializes a new JCanvas3DOB object that Java 3D
     * can render into, using the specified graphics device.
     *
     * @param device the screen graphics device that will be used to construct
     *        a GraphicsConfiguration.
     */
    public JCanvas3DOB(GraphicsDevice device) {
        this(null, device);
    }

    /**
     * Constructs and initializes a new JCanvas3DOB object that Java 3D
     * can render into, using the specified template.
     * The screen device is obtained from
     * <code>GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice()</code>,
     * which might not be the one you should use if you are
     * in a multiscreen environment.
     *
     * @param template The template that will be used to construct a
     *        GraphicsConfiguration. The stereo and doublebuffer properties
     *        are forced to UNNECESSARY.
     */
    public JCanvas3DOB(GraphicsConfigTemplate3D template) {
        this(template, null);
    }

    /**
     * Constructs and initializes a new JCanvas3DOB object that Java 3D
     * can render into, using the specified template and graphics device.
     *
     * @param template The template that will be used to construct a
     *        GraphicsConfiguration. The stereo and doublebuffer properties
     *        are forced to UNNECESSARY.
     * @param device the screen graphics device that will be used to construct
     *        a GraphicsConfiguration in conjunction with the template.
     */
    public JCanvas3DOB(GraphicsConfigTemplate3D template, GraphicsDevice device) {       
        super(template, device);
    }

    
    /**
     * {@inheritDoc}
     * <p>
     * A JCanvas3DOB object calls 
     * <code>super.createOffScreenBuffer(canvasWidth, canvasHeight)</code> 
     * with the given size.   
     * </p>
     * @param width {@inheritDoc}
     * @param height {@inheritDoc}
     */
    @Override
    protected void createOffScreenBuffer(int width, int height) {
        super.createOffScreenBuffer(width, height);       
    }
    
    /**
     * {@inheritDoc}
     * <p>
     * A JCanvas3DOB object provides an empty implementation.   
     * </p>
     */
    @Override
    protected void offScreenBufferCreated () {       
    }
    
    /**
     * {@inheritDoc}
     *    
     * <p>
     * A JCanvas3DOB object provides an empty implementation.   
     * </p>
     */
    @Override
    protected void offScreenBufferCopied() {        
    }

    /**
     * Flips and paints the result of the 3D rendering.
     *
     * @param g {@inheritDoc}
     */
    @Override
    public void paintComponent(Graphics g) {
        
        super.paintComponent(g); // paint background
                
        // Draw & flip offscreen buffer        
        if (isReadyForDrawing()) {
            g.drawImage(paintImage,
                    // destination in g2d: flip lowerY and upperY 
                    // dx1    dy1          dx2         dy2
                        0, imageHeight, imageWidth, 0,    
                    // source: the bottom part of the scene image
                    // sx1    sy1          sx2         sy2
                        0, 0,           imageWidth, imageHeight, null);
        }                
    }
}
